% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence_of.R
\name{influence_of}
\alias{influence_of}
\title{Influence Of Internal Knots}
\usage{
influence_of(x, indices, ...)
}
\arguments{
\item{x}{a \code{cpr_cp} object}

\item{indices}{an integer vector specifying the elements of \code{attr(x,
"knots")} to assess.  Defaults to all internal knots.}

\item{...}{Additional arguments passed to \code{\link{influence_weights}}.}
}
\value{
A \code{cpr_influence_of} object.  This is a list with the following
elements:
\describe{
  \item{weight}{A \code{data.frame} showing the influence weight and
  relative rank of each internal knot}
  \item{orig_cp}{The original control polygon}
  \item{indices}{The indices of the internal knots assessed.}
  \item{coarsened_cp}{A list of control polygons.  These are the control
  polygons built on the coarsened knot sequence}
 \item{reinserted_cp}{A list of control polygons.  These are the control
 polygons resulting from the reinsertion of the assessed internal knot.}
}
}
\description{
Given a control polygon and set of indices, return the influence weight for
the specified internal knots and generate graphics showing the original,
coarsened, and approximated control polygons.
}
\seealso{
\code{\link{plot.cpr_influence_of}}, \code{\link{cp}}
}
