\name{copyLpCPLEX}
\alias{copyLpCPLEX}
\alias{CPXcopylp}

\title{
  Copy Data Defining an LP Problem to a CPLEX Problem Object.
}

\description{
  Low level interface function to the IBM ILOG CPLEX function
  \code{CPXcopylp}.  Consult the IBM ILOG CPLEX documentation for more
  detailed information.
}

\usage{
  copyLpCPLEX(env, lp, nCols, nRows, lpdir, objf, rhs, sense,
              matbeg, matcnt, matind, matval, lb, ub, rngval = NULL)
}

\arguments{
  \item{env}{
    Pointer to an IBM ILOG CPLEX environment as returned by
    \code{\link{openEnvCPLEX}}.
  }
  \item{lp}{
    Pointer to an IBM ILOG CPLEX problem object as returned by
    \code{\link{initProbCPLEX}}.
  }
  \item{nCols}{
    Number of columns in the constraint matrix.
  }
  \item{nRows}{
	Number of rows in the constraint matrix.
  }
  \item{lpdir}{
    Single integer value that specifies whether the problem is a minimization
    or maximization problem.
  }
  \item{objf}{
    The objective function coefficients.
  }
  \item{rhs}{
	The righthand side values for each constraint in the constraint matrix.
  }
  \item{sense}{
	The sense of each constraint in the constraint matrix.
  }
  \item{matbeg}{
    Array that defines the constraint matrix. Consult the IBM ILOG CPLEX
    documentation for more detailed information.
  }
  \item{matcnt}{
    Array that defines the constraint matrix. Consult the IBM ILOG CPLEX
    documentation for more detailed information.
  }
  \item{matind}{
    Array that defines the constraint matrix. Consult the IBM ILOG CPLEX
    documentation for more detailed information.
  }
  \item{matval}{
    Array that defines the constraint matrix. Consult the IBM ILOG CPLEX
    documentation for more detailed information.
  }
  \item{lb}{
	Containing the lower bound on each of the variables.
  }
  \item{ub}{
	Containing the lower bound on each of the variables.
  }
  \item{rngval}{
	Containing the range value of each ranged constraint.
  }
}

\details{
  Interface to the C function \code{copyLp} which calls the CPLEX
  function \code{CPXcopylp}.
}

\value{
  Zero if successful, otherwise nonzero.
}

\references{
  The IBM ILOG CPLEX home page at
  \url{https://www.ibm.com/developerworks/university/academicinitiative/}.
}

\author{
  Gabriel Gelius-Dietrich

  Maintainer: Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>
}

\keyword{ optimize }
