% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootcov2.R
\name{bootcov2}
\alias{bootcov2}
\title{Boostrapping algorithm for \code{coxed}}
\usage{
bootcov2(fit, cluster, B = 200, fitter, coef.reps = TRUE,
  loglik = FALSE, pr = FALSE, maxit = 15, group = NULL,
  stat = NULL)
}
\arguments{
\item{fit}{an estimated Cox proportional hazards model object with
class "coxph" or "cph"}

\item{cluster}{a variable indicating groupings. \code{cluster} may
be any type of vector (factor, character, integer). Unique values
of \code{cluster} indicate possibly correlated groupings of observations.
Note the data used in the fit and stored in \code{fit$x} and \code{fit$y}
may have had observations containing missing values deleted. It is assumed
that if there were any \code{NA}s, an \code{naresid} function exists for
the class of fit. This function restores \code{NA}s so that the rows of
the design matrix coincide with \code{cluster}}

\item{B}{Number of bootstrap simulation iterations}

\item{fitter}{the name of a function with arguments \code{(x,y)} that will fit
bootstrap samples. Default is taken from the class of fit if it is \code{ols},
\code{lrm}, \code{cph}, \code{psm}, \code{Rq}. If \code{fitter="tvc"} the
function employs \code{\link[survival]{agreg.fit}}}

\item{coef.reps}{set to \code{TRUE} if you want to store a matrix of all
bootstrap regression coefficient estimates in the returned component \code{boot.Coef}.}

\item{loglik}{set to \code{TRUE} to store -2 log likelihoods for each bootstrap model,
evaluated against the original \code{x} and \code{y} data. The default is to do this when
\code{coef.reps} is specified as \code{TRUE}. The use of \code{loglik=TRUE} assumes
that an \code{oos.loglik} method exists for the type of model being analyzed, to calculate
out-of-sample -2 log likelihoods (see \code{rmsMisc}). After the B -2 log likelihoods
(stored in the element named \code{boot.loglik} in the returned fit object), the \code{B+1}
element is the -2 log likelihood for the original model fit}

\item{pr}{set to \code{TRUE} to print the current sample number to monitor progress}

\item{maxit}{maximum number of iterations, to pass to \code{fitter}}

\item{group}{a grouping variable used to stratify the sample upon bootstrapping. This
allows one to handle \code{k}-sample problems, i.e., each bootstrap sample will be forced
to select the same number of observations from each level of group as the number appearing
in the original dataset. You may specify both \code{group} and \code{cluster}}

\item{stat}{a single character string specifying the name of a \code{stats} element produced
by the fitting function to save over the bootstrap repetitions. The vector of saved statistics
will be in the \code{boot.stats} part of the list returned by \code{bootcov}}
}
\description{
This function uses bootstrapping to create standard errors and
confidence intervals for the quantities produced by the coxed()
function. It is adapted from the \code{\link[rms]{bootcov}} function
in the \code{\link[rms]{rms}} package. It is called by the \code{\link[coxed]{coxed}}
function and is not intended to be used by itself.  Please refer to
the original \code{\link[rms]{bootcov}} function for general bootstrapping
applications.
}
\details{
This function contains the same code as the \code{\link[rms]{bootcov}} function in
the \code{\link[rms]{rms}} package, with a few alterations to work better with the \code{\link[coxed]{coxed}}
function. First, we output a result attribute \code{b.ind}, which contains the observation numbers from the estimation sample
that are drawn with replacement to produce the bootstrap sample and takes into account clustering.
Second, we program a new class, \code{tvc}, for
\code{fitter} to use \code{\link[survival]{agreg.fit}} instead of \code{\link[survival]{coxph.fit}}
when the data contain time-varying covariates.
}
\seealso{
\code{\link[coxed]{coxed}}, \code{\link[survival]{coxph}}, \code{\link[rms]{cph}}, \code{\link[rms]{bootcov}}
}
\author{
Jonathan Kropko <jkropko@virginia.edu> and Jeffrey J. Harden <jharden@nd.edu>, based
on the code for the \code{\link[rms]{bootcov}} function in the \code{\link[rms]{rms}} package
by Frank Harrell and Bill Pikounis
}
