% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covid19_models.R
\name{generate.SIR.model}
\alias{generate.SIR.model}
\title{function to generate a simple SIR (Susceptible-Infected-Recovered) model based on the actual data of the coivd19 cases}
\usage{
generate.SIR.model(
  data = NULL,
  geo.loc = "Hubei",
  t0 = NULL,
  t1 = NULL,
  deltaT = NULL,
  tfinal = 90,
  fatality.rate = 0.02,
  tot.population = 1.4e+09,
  staticPlt = TRUE,
  interactiveFig = FALSE,
  add.extras = FALSE
)
}
\arguments{
\item{data}{time series dataset to consider}

\item{geo.loc}{country/region to analyze}

\item{t0}{initial period of time for data consideration}

\item{t1}{final period of time for data consideration}

\item{deltaT}{interval period of time from t0, ie. number of days to consider since t0}

\item{tfinal}{total number of days}

\item{fatality.rate}{rate of causality, deafault value of 2 percent}

\item{tot.population}{total population of the country/region}

\item{staticPlt}{optional flag to activate/deactive plotting of the data and the SIR model generated}

\item{interactiveFig}{optional flag to activate/deactive the generation of an interactive plot of the data and the SIR model generated}

\item{add.extras}{boolean flag to add extra indicators, such as, the "force of infection" and time derivatives}
}
\description{
function to generate a simple SIR (Susceptible-Infected-Recovered) model based on the actual data of the coivd19 cases
}
\examples{
data <- covid19.data("ts-confirmed")
generate.SIR.model(data,"Hubei", t0=1,t1=15)
generate.SIR.model(data,"Germany",tot.population=83149300)
generate.SIR.model(data,"Uruguay", tot.population=3500000)
generate.SIR.model(data,"Canada", tot.population=37590000, add.extras=TRUE)

}
