% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covid19.R
\name{covid19.data}
\alias{covid19.data}
\title{function to read "live" data from reported covid19 cases}
\usage{
covid19.data(case = "aggregated", local.data = FALSE, debrief = FALSE)
}
\arguments{
\item{case}{a string indicating the category of the data, possible values are:
"aggregated" :  latest number of cases *aggregated* by country,
"ts-confirmed" :  time data of confirmed cases,
"ts-deaths"    :  time series data of fatal cases,
"ts-recovered" :  time series data of recovered cases,
"ts-ALL"       :  all time series data combined,
"ts-confirmed-US"  : time series data of confirmed cases for the United States,
"ts-deaths-US"     : time series data of fatal cases for the United States,
"ts-dep-confirmed" : time series data of confirmed cases as originally reported (depricated),
"ts-dep-deaths"    : time series data of deaths as originally reported (depricated),
"ts-dep-recovered" : time series data of recovered cases as originally reported (depricated),
"ALL": all of the above
"ts-Toronto"       :  data for the City of Toronto, ON - Canada}

\item{local.data}{boolean flag to indicate whether the data will be read from the local repo, in case of connectivity issues or data integrity}

\item{debrief}{boolean specifying whether information about the read data is going to be displayed in screen}
}
\value{
a dataframe (or a list in the case of "ALL") with the daily worlwide indicated type of data per country/region/city
}
\description{
function to read "live" data from reported covid19 cases
}
\examples{
\donttest{
# reads all possible datastest, returnin a list
covid19.all.datasets <- covid19.data("ALL")
}
# reads the latest aggregated data
covid19.ALL.agg.cases <- covid19.data("aggregated")
# reads time series data for casualities
covid19.TS.deaths <- covid19.data("ts-deaths")

}
