% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lap_solve.R
\name{bottleneck_assignment}
\alias{bottleneck_assignment}
\title{Solve the Bottleneck Assignment Problem}
\usage{
bottleneck_assignment(cost, maximize = FALSE)
}
\arguments{
\item{cost}{Numeric matrix; rows = tasks, columns = agents. \code{NA} or \code{Inf}
entries are treated as forbidden assignments.}

\item{maximize}{Logical; if \code{TRUE}, maximizes the minimum edge cost instead
of minimizing the maximum (maximin objective). Default is \code{FALSE} (minimax).}
}
\value{
A list with class \code{"bottleneck_result"} containing:
\itemize{
\item \code{match} - integer vector of length \code{nrow(cost)} giving the
assigned column for each row (1-based indexing)
\item \code{bottleneck} - numeric scalar, the bottleneck (max/min edge) value
\item \code{status} - character scalar, e.g. \code{"optimal"}
}
}
\description{
Finds an assignment that minimizes (or maximizes) the maximum edge cost
in a perfect matching. Unlike standard LAP which minimizes the sum of costs,
BAP minimizes the maximum (bottleneck) cost.
}
\details{
The Bottleneck Assignment Problem (BAP) is a variant of the Linear Assignment
Problem where instead of minimizing the sum of assignment costs, we minimize
the maximum cost among all assignments (minimax objective).

\strong{Algorithm:}
Uses binary search on the sorted unique costs combined with 'Hopcroft-Karp'
bipartite matching to find the minimum threshold that allows a perfect matching.

\strong{Complexity:} O(E * sqrt(V) * log(unique costs)) where E = edges, V = vertices.

\strong{Applications:}
\itemize{
\item Task scheduling with deadline constraints (minimize latest completion)
\item Resource allocation (minimize maximum load/distance)
\item Network routing (minimize maximum link utilization)
\item Fair division problems (minimize maximum disparity)
}
}
\examples{
# Simple example: minimize max cost
cost <- matrix(c(1, 5, 3,
                 2, 4, 6,
                 7, 1, 2), nrow = 3, byrow = TRUE)
result <- bottleneck_assignment(cost)
result$bottleneck  # Maximum edge cost in optimal assignment

# Maximize minimum (fair allocation)
profits <- matrix(c(10, 5, 8,
                    6, 12, 4,
                    3, 7, 11), nrow = 3, byrow = TRUE)
result <- bottleneck_assignment(profits, maximize = TRUE)
result$bottleneck  # Minimum profit among all assignments

# With forbidden assignments
cost <- matrix(c(1, NA, 3,
                 2, 4, Inf,
                 5, 1, 2), nrow = 3, byrow = TRUE)
result <- bottleneck_assignment(cost)

}
\seealso{
\code{\link[=assignment]{assignment()}} for standard LAP (sum objective), \code{\link[=lap_solve]{lap_solve()}} for
tidy LAP interface
}
