% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_timecol.R
\name{find_timecol}
\alias{find_timecol}
\title{Finds columns containing date and year data}
\usage{
find_timecol(x, return_index = FALSE, allow_NA = TRUE, sample_size = 1000)
}
\arguments{
\item{x}{A data frame object}

\item{return_index}{A logical value indicating whether the function should return the index of time columns instead of the column names. Default is \code{FALSE}, column names are returned.}

\item{allow_NA}{Logical value indicating whether to allow time columns to contain \code{NA} values. Default is \code{allow_NA=FALSE}, the function will not return time column containing \code{NA} values.}

\item{sample_size}{Either \code{NA} or a numeric value indicating the sample size used for evaluating columns. Default is \code{1000}. If \code{NA} is passed, the function will evaluate the full table. The minimum accepted value is \code{100} (i.e. 100 randomly sampled rows are used to evaluate the columns). This parameter can be tuned to speed up computation on long datasets. Taking a sample could result in inexact identification of key columns, accuracy improves with larger samples.}
}
\value{
Returns a vector of names (\code{return_index=FALSE}) or indices (\code{return_index=TRUE}) of columns containing date or year information. Only the most likely year column is returned.
}
\description{
This function takes a data frame as argument and returns the column names (or indices) of all columns containing dates and the most likely column containing year information, if any.
It can be used to automate the search of date and year columns in data frames.
}
\examples{
find_timecol(x=data.frame(a=1970:2020, year=1970:2020, b=rep("2020-01-01",51),c=sample(1:1000,51)))
}
\seealso{
\link[countries]{is_date}, \link[countries]{find_countrycol}
}
