% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{plot_fitted}
\alias{plot_fitted}
\title{Plot the fitted values and the data}
\usage{
plot_fitted(y, post_y, y_hat = NULL, alpha = 0.05, ...)
}
\arguments{
\item{y}{\code{n x 1} vector of data}

\item{post_y}{\code{Nsims x n} matrix of simulated fitted values, where \code{Nsims} is the
number of simulations}

\item{y_hat}{\code{n x 1} vector of fitted values; if NULL, use the pointwise sample mean \code{colMeans(post_y)}}

\item{alpha}{confidence level for the credible intervals}

\item{...}{other arguments for plotting}
}
\value{
A plot with the fitted values and the credible intervals against the data
}
\description{
Plot the fitted values, plus pointwise credible intervals, against the
data. For simulations, one may use the true values in place of the data.
}
