% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{sample_lm_ridge}
\alias{sample_lm_ridge}
\title{Sample linear regression parameters assuming a ridge prior}
\usage{
sample_lm_ridge(y, X, params, A = 10^4, XtX = NULL, X_test = NULL)
}
\arguments{
\item{y}{\code{n x 1} vector of data}

\item{X}{\code{n x p} matrix of predictors}

\item{params}{the named list of parameters containing
\enumerate{
\item \code{mu}: vector of conditional means (fitted values)
\item \code{sigma}: the conditional standard deviation
\item \code{coefficients}: a named list of parameters that determine \code{mu}
}}

\item{A}{the prior scale for \code{sigma_beta}, which we assume follows a Uniform(0, A) prior.}

\item{XtX}{the \code{p x p} matrix of \code{crossprod(X)} (one-time cost);
if NULL, compute within the function}

\item{X_test}{matrix of predictors at test points (default is NULL)}
}
\value{
The updated named list \code{params} with draws from the full conditional distributions
of \code{sigma} and \code{coefficients} (along with updated \code{mu} and \code{mu_test} if applicable).
}
\description{
Sample the parameters for a linear regression model assuming a
ridge prior for the (non-intercept) coefficients. The number of predictors
\code{p} may exceed the number of observations \code{n}.
}
\note{
The parameters in \code{coefficients} are:
\itemize{
\item \code{beta}: the \code{p x 1} vector of regression coefficients
\item \code{sigma_beta}: the prior standard deviation for the (non-intercept)
components of \code{beta}
}
}
\keyword{internal}
