% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predictive.cosimmr_output.R
\name{posterior_predictive}
\alias{posterior_predictive}
\title{Plot the posterior predictive distribution for a cosimmr run}
\usage{
posterior_predictive(
  cosimmr_out,
  prob = 0.5,
  plot_ppc = TRUE,
  n_samples = 3600,
  sort_data = TRUE
)
}
\arguments{
\item{cosimmr_out}{A run of the cosimmr model from \code{\link{cosimmr_ffvb}}.}

\item{prob}{The probability interval for the posterior predictives. The default is 0.5 (i.e. 50pc intervals)}

\item{plot_ppc}{Whether to create a bayesplot of the posterior predictive or not.}

\item{n_samples}{The number of samples you wish to generate for y_pred. Defaults to 3600.}

\item{sort_data}{Whether to order the data from lowest to highest predicted mean or not. Defaults to TRUE.}
}
\value{
plot of posterior predictives and simulated values

#' @author Emma Govan <emmagovan@gmail.com> Andrew Parnell
}
\description{
This function takes the output from  \code{\link{cosimmr_ffvb}} and plots 
the posterior predictive distribution to enable visualisation of model fit.
The simulated posterior predicted values are returned as part of the object 
and can be saved for external use
}
\examples{
\donttest{
data(geese_data_day1)
cosimmr_1 <- with(
  geese_data_day1,
  cosimmr_load(
    formula = mixtures ~ c(1,2,3,2,1,2,3,2,1),
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)

# Plot
plot(cosimmr_1)

# Print
cosimmr_1

# FFVB run
cosimmr_1_out <- cosimmr_ffvb(cosimmr_1)

# Prior predictive
post_pred <- posterior_predictive(cosimmr_1_out)
}
}
\seealso{
\code{\link{cosimmr_ffvb}} for creating objects suitable for this
function
}
