% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corx.R
\name{corx}
\alias{corx}
\title{corx}
\usage{
corx(
  data,
  x = NULL,
  y = NULL,
  z = NULL,
  method = c("pearson", "spearman", "kendall"),
  stars = c(0.05),
  round = 2,
  remove_lead = TRUE,
  triangle = NULL,
  caption = NULL,
  note = NULL,
  describe = FALSE,
  grey_nonsig = TRUE
)
}
\arguments{
\item{data}{A data.frame or matrix}

\item{x}{a vector of rownames. Defaults to all}

\item{y}{a vector of colnames. If not supplied, y is set to x.}

\item{z}{a vector of colnames. Control variables to be used in partial correlations - defaults to NULL}

\item{method}{a string. One of "pearson", "spearman", or "kendall"}

\item{stars}{a numeric vector. This argument defines cut-offs for p-value stars.}

\item{round}{a scalar. Number of digits in printing}

\item{remove_lead}{a logical. if TRUE (the default), leading zeros are removed in summaries}

\item{triangle}{one of "lower", "upper" or NULL (the default)}

\item{caption}{table caption. Passed to plots}

\item{note}{table note}

\item{describe}{a list of functions. If functions are supplied to describe, new columns will be bound to the 'APA matrix' for each function in the list. Describe also accepts a variety of shortcuts. If describe is set to TRUE, mean and standard deviation are returned for all row variables. Describe can accept a character vector to call the following descriptive functions: c('mean','sd','var','median','iqr','skewness','kurtosis'). These shortcuts are powered by 'tidyselect'. Skewness and kurtosis are calculated using the 'moments' package. All functions retrieved with shortcuts remove missing values.}

\item{grey_nonsig}{a logical. Should non-significant values be grey in output? This argument does nothing if describe is not set to FALSE}
}
\value{
A list of class 'corx' which includes:
\itemize{
 \item{"call"}{ The call}
 \item{"apa"}{ An 'APA' formatted correlation matrix with significance stars}
 \item{"r"}{ Raw correlation coefficients}
 \item{"p"}{ Raw p-values}
 \item{"n"}{ Pairwise observations}
 \item{"caption"}{ Object caption}
 \item{"note"}{ Object note}
}
}
\description{
Creates an object of class 'corx'. This function calculates correlation matrices. It stores effect sizes, p-values, the number of pairwise observations, and a formatted correlation matrix in a list. The argument 'z' allows for control variables to be assigned. If z does not equal NULL, partial correlations are performed. Methods are exported for the generic functions 'print', 'plot', 'summary', 'data.frame' and, 'coef'.
}
\details{
'corx' constructs intercorrelation matrices using 'psych::corr.test'. P-values attained are not adjusted for multiple comparisons. The argument z can be used to specify control variables. If control variables are specified, partial correlations are calculated using 'ppcor::ppcor.test'. Asymmetrical correlation matrices can be constructed using the arguments 'x' and 'y'. The arguments 'x', 'y', and 'z' are powered by 'tidyselect::vars_select'.
}
\examples{
cor_mat <- corx(mtcars, x = c(mpg,cyl,disp), y = c(wt,drat,disp,qsec),
           z = wt, round = 2, stars = c(0.05),
           caption = "Controlling for weight" ,
           describe = list("mean" = function(x) mean(x,na.rm=TRUE)))
cor_mat
coef(cor_mat)
cor_mat$p
plot(cor_mat)
cor_2 <- corx(iris[,-5], describe = c(median, IQR = iqr, kurt = kurtosis),
         note = "Using shortcuts to select describe functions", triangle = "lower")
cor_2
}
