% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{val2col}
\alias{val2col}
\title{val2col - Convert a numeric vector into colors}
\usage{
val2col(
  z,
  col1 = "navy",
  col2 = "white",
  col3 = "red3",
  nbreaks = 1000,
  center = TRUE,
  rank = FALSE
)
}
\arguments{
\item{z}{a vector of numbers}

\item{col1}{a color name for the min value, default 'navy'}

\item{col2}{a color name for the middle value, default 'white'}

\item{col3}{a color name for the max value, default 'red3'}

\item{nbreaks}{Number of colors to be generated. Default is 30.}

\item{center}{boolean, should the data be centered? Default is TRUE}

\item{rank}{boolean, should the data be ranked? Default is FALSE}
}
\value{
a vector of colors
}
\description{
val2col - Convert a numeric vector into colors
}
\examples{
a<-rnorm(1000)
cols<-val2col(a)
plot(a,col=cols,pch=16)
}
