% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr2d_plot.R
\name{plot_corr2d}
\alias{plot_corr2d}
\title{Plot two-dimensional correlation spectra.}
\usage{
plot_corr2d(
  Obj,
  what = Re(Obj$FT),
  specx = Obj$Ref1,
  specy = Obj$Ref2,
  xlim = NULL,
  ylim = NULL,
  xlab = expression(nu[1]),
  ylab = expression(nu[2]),
  Contour = TRUE,
  axes = 3,
  Legend = TRUE,
  N = 20,
  zlim = NULL,
  Cutout = NULL,
  col = par("col"),
  lwd = par("lwd"),
  lwd.axis = NULL,
  lwd.spec = NULL,
  cex.leg = NULL,
  at.xaxs = NULL,
  label.xaxs = TRUE,
  at.yaxs = NULL,
  label.yaxs = TRUE,
  line.xlab = 3.5,
  line.ylab = 3.5,
  ...
)
}
\arguments{
\item{Obj}{List from \code{corr2d} containing the 2D correlation data.}

\item{what}{Real numeric matrix containing the z-values that should be plotted.}

\item{specx, specy}{Numeric vector containing the data that should be plotted
on top (\code{specx}) and/or on the left (\code{specy}) of
the 2D spectrum. \code{Mat}, \code{specx} and/or \code{specy} should
have the same dimensions, respectively. If \code{NULL} nothing will
be plotted.}

\item{xlim, ylim}{Numeric vector with two values indicating the borders
of the 2D plot. Also truncates \code{specx} and/or \code{specy} to
match the new plot range.}

\item{xlab, ylab}{Character or expression containing the text that will
be plotted on the bottom (\code{xlab}) and/or to the right
(\code{ylab}) of the 2D plot. Labels can be suppressed with \code{NA}.}

\item{Contour}{Logical: Should a contour (\code{TRUE}) or image
(\code{FALSE}) be drawn?}

\item{axes}{Integer ranging from 0 to 3. Should the axis of the 2D plot
be drawn? "0" means no axes, "1" only bottom axis, "2" only right axis and
"3" both axes are drawn.}

\item{Legend}{Logical: Should a color legend be plotted in the top
right corner?}

\item{N}{Positive, non-zero integer indicating how many contour or image
levels should be plotted.}

\item{zlim}{Numeric vector with two values defining the z-range of the 2D
plot.}

\item{Cutout}{Numeric vector with two values defining which z-values should
not be plotted. Use with care, because this can generate misleading
2D plots.}

\item{col}{A specification for the plotting color of the reference spectra
(top and left), axes, axes ticks and the central plot surrounding box.
See \code{\link[graphics]{par}} and \code{\link[graphics]{contour}} for
additional information.}

\item{lwd}{A numeric value which sets the line width in the contour plot. See
\code{\link[graphics]{par}} and \code{\link[graphics]{contour}} for
additional information.}

\item{lwd.axis}{A numeric value which sets the line width for axes and the
central plot surrounding box. See \code{\link[graphics]{par}} and
\code{\link[graphics]{axis}} for additional information.}

\item{lwd.spec}{A numeric value which sets the line width in the reference
spectra on top and to the left. See \code{\link[graphics]{par}} and 
\code{\link[graphics]{plot.default}} for additional information.}

\item{cex.leg}{A numerical value giving the amount by which numbers at the
legend should be magnified. See \code{\link[graphics]{par}} and 
\code{\link[fields]{image.plot}} for additional information.}

\item{at.xaxs, at.yaxs}{The points at which tick-marks are to be drawn at the
x- and y-axis, respectively. See \code{\link[graphics]{axis}} for
additional information.}

\item{label.xaxs, label.yaxs}{This can either be a logical value specifying
whether (numerical) annotations are to be made at the tickmarks of the
x- and y-axis, or a character or expression vector of labels to be
placed at the tickpoints of the x- and y-axis. See
\code{\link[graphics]{axis}} for additional information.}

\item{line.xlab, line.ylab}{Numeric value on which MARgin line the x- and
y-label is plotted, respectively, starting at 0 counting outwards. See
\code{\link[graphics]{mtext}} for additional information.}

\item{...}{Additional arguments either passed to
\code{\link[graphics]{image}} or \code{\link[graphics]{contour}}. Can
include graphics parameters \code{\link[graphics]{par}} which are in
part also used by other functions. This includes \code{cex.axis}
(influences axes and thier label magnification), \code{cex.lab}
(influences label magnification), \code{col.axis} (influences axes
label color), \code{col.lab} (influences label color),
\code{font.axis} (influences axes label font), \code{font.lab}
(influences label font) and \code{lty} (influences line type for contour
plot).}
}
\description{
\code{plot_corr2d} plots two-dimensional correlation spectra either
    as an image or a contour plot. Red color indicates positive
    correlations, while blue color shows negative ones.
}
\details{
For the synchronous correlation spectrum the real component (\code{Re})
    of the complex correlation matrix must be plotted. The asynchronous
    spectrum is the respective imaginary component (\code{Im}).
    \code{Cutout} can be used to leave out smaller (noise) contributions,
    but should be used with care as it can be used to create misleading
    2D correlation plots. See references for interpretation rules (so
    called Noda rules).
}
\examples{
    data(FuranMale, package = "corr2D")
    twod <- corr2d(FuranMale, Ref1 = FuranMale[1, ], corenumber = 1)
    
    plot_corr2d(twod, xlab = expression(paste("relative Wavenumber" / cm^-1)),
                      ylab = expression(paste("relative Wavenumber" / cm^-1)))
                      
    plot_corr2d(twod, at.xaxs = c(1560, 1585, 1610),
                label.xaxs = c(1560, 1585, 1610),
                col = 2, lwd = 3, col.axis = 3, col.lab = 4, Legend = FALSE,
                cex.lab = 3, xlab = "Large x label", ylab = "Large y label",
                line.xlab = 5, line.ylab = 5)

}
\references{
For interpretation rules see:
    I. Noda (2006) <DOI:10.1016/j.molstruc.2005.12.060>\cr
    R. Geitner et al. (2019) <DOI:10.18637/jss.v090.i03>
}
\seealso{
See \code{\link{plot_corr2din3d}} for 3D plots.
}
