% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ego_network.r
\name{ego_semnet}
\alias{ego_semnet}
\title{Create an ego network}
\usage{
ego_semnet(g, vertex_names, depth = 1, only_filter_vertices = T,
  weight_attr = "weight", min_weight = NULL, top_edges = NULL,
  max_edges_level = NULL, directed = c("out", "in"))
}
\arguments{
\item{g}{an igraph object}

\item{vertex_names}{a character string with the names of the ego vertices/nodes}

\item{depth}{the number of degrees from the ego vertices/nodes that are included. 1 means that only the direct neighbours are included}

\item{only_filter_vertices}{if True, the algorithm will only filter out vertices/nodes that are not in the ego network. If False (default) then it also filters out the edges.}

\item{weight_attr}{the name of the edge attribute. if NA, no weight is used, and min_weight and top_edges are ignored}

\item{min_weight}{a number indicating the minimum weight}

\item{top_edges}{for each vertex within the given depth, only keep the top n edges with the strongest edge weight. Can also be a vector of the same length as the depth value, in which case a different value is used at each level: first value for level 1, second value for level 2, etc.}

\item{max_edges_level}{the maximum number of edges to be added at each level of depth.}

\item{directed}{if the network is directed, specify whether 'out' degrees or 'in' degrees are used}
}
\description{
Create an ego network from an igraph object.
}
\details{
The function is similar to the ego function in igraph, but with some notable differences. Firstly, if multiple vertex_names are given, the ego network for both is given in 1 network (whereas igraph creates a list of networks). Secondly, the min_weight and top_edges parameters can be used to focus on the strongest edges.
}
\examples{
tc = create_tcorpus(c('a b c', 'd e f', 'a d'))
g = tc$semnet('token')

igraph::get.data.frame(g)
\donttest{plot_semnet(g)}
## only keep nodes directly connected to given node
g_ego = ego_semnet(g, 'e')
igraph::get.data.frame(g_ego)
\donttest{plot_semnet(g_ego)}

## only keep edges directly connected to given node
g_ego = ego_semnet(g, 'e', only_filter_vertices = FALSE)
igraph::get.data.frame(g_ego)
\donttest{plot_semnet(g_ego)}

## only keep nodes connected to given node with a specified degree (i.e. distance)
g_ego = ego_semnet(g, 'e', depth = 2)
igraph::get.data.frame(g_ego)
\donttest{plot_semnet(g_ego)}
}
