% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.r
\name{tCorpus$dtm}
\alias{tCorpus$dtm}
\alias{tCorpus$dfm}
\title{Create a document term matrix.}
\arguments{
\item{feature}{The name of the feature column}

\item{context_level}{Select whether the rows of the dtm should represent "documents" or "sentences".}

\item{weight}{Select the weighting scheme for the DTM. Currently supports term frequency (termfreq), document frequency (docfreq), term frequency inverse document frequency (tfidf) and tfidf with normalized document vectors.}

\item{drop_empty_terms}{If True, tokens that do not occur (i.e. column where sum is 0) are ignored.}

\item{form}{The output format. Default is a sparse matrix in the dgTMatrix class from the Matrix package. Alternatives are tm_dtm for a DocumentTermMatrix in the tm package format or quanteda_dfm for the document feature matrix from the quanteda package.}

\item{subset_tokens}{A subset call to select which rows to use in the DTM}

\item{subset_meta}{A subset call for the meta data, to select which documents to use in the DTM}

\item{context}{Instead of using the document or sentence context, an custom context can be specified. Has to be a vector of the same length as the number of tokens, that serves as the index column. Each unique value will be a row in the DTM.}

\item{context_labels}{If False, the DTM will not be given rownames}

\item{feature_labels}{If False, the DTM will not be given column names}

\item{ngrams}{Optionally, use ngrams instead of individual tokens. This is more memory efficient than first creating an ngram feature in the tCorpus.}

\item{ngram_before_subset}{If a subset is used, ngrams can be made before the subset, in which case an ngram can contain tokens that have been filtered out after the subset. Alternatively, if ngrams are made after the subset, ngrams will span over the gaps of tokens that are filtered out.}
}
\description{
Create a document term matrix. The default output is a sparse matrix (Matrix, dgTMatrix). Alternatively, the dtm style from the tm and quanteda package can be used.

The tCorpus$dfm method is shorthand for using quanteda's dfm (document feature matrix) class. The meta data in the tcorpus is then automatically added as docvars in the dfm.

\strong{Usage:}

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{dtm(feature, context_level = c('document','sentence'), weight = c('termfreq','docfreq','tfidf','norm_tfidf'),
    drop_empty_terms = T, form = c('Matrix', 'tm_dtm', 'quanteda_dfm'), subset_tokens = NULL, subset_meta = NULL,
    context = NULL, context_labels = T, feature_labels = T, ngrams = NA, ngram_before_subset = F)}

\preformatted{dfm(feature, ...)   ## identical, but without form argument}
}
\examples{
tc = create_tcorpus(c("First text first sentence. First text first sentence.",
                   "Second text first sentence"), doc_column = 'id', split_sentences = TRUE)

## Perform additional preprocessing on the 'token' column, and save as the 'feature' column
tc$preprocess('token', 'feature', remove_stopwords = TRUE, use_stemming = TRUE)
tc$tokens

## default: regular sparse matrix, using the Matrix package
m = tc$dtm('feature')
class(m)
m

## alternatively, create quanteda ('quanteda_dfm') or tm ('tm_dtm') class for DTM
\donttest{
m = tc$dtm('feature', form = 'quanteda_dfm')
class(m)
m
}

## create DTM with sentences as rows (instead of documents)
m = tc$dtm('feature', context_level = 'sentence')
nrow(m)

## use weighting
m = tc$dtm('feature', weight = 'norm_tfidf')
}
