% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.r
\name{tCorpus$feature_stats}
\alias{tCorpus$feature_stats}
\title{Feature statistics}
\arguments{
\item{feature}{The name of the feature column}

\item{sent_freq}{If True, include sentence frequency (only if sentence information is available).}
}
\description{
Compute a number of useful statistics for features: term frequency, idf, etc.

\strong{Usage:}

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{feature_stats(feature, sent_freq=F)}
}
\examples{
tc = create_tcorpus(c('Text one first sentence. Text one second sentence', 'Text two'),
                    split_sentences = TRUE)

fs = tc$feature_stats('token')
head(fs)

fs = tc$feature_stats('token', context_level = 'sentence')
head(fs)
}
