% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_tcorpus.r
\name{freq_filter}
\alias{freq_filter}
\title{Support function for subset method}
\usage{
freq_filter(x, min = -Inf, max = Inf, top = NULL, bottom = NULL)
}
\arguments{
\item{x}{the name of the feature column. Can be given as a call or a string.}

\item{min}{A number, setting the minimum frequency value}

\item{max}{A number, setting the maximum frequency value}

\item{top}{A number. If given, only the top x features with the highest frequency are TRUE}

\item{bottom}{A number. If given, only the bottom x features with the highest frequency are TRUE}
}
\description{
Support function to enable subsetting by frequency stats of a given feature.
Should only be used within the tCorpus subset method, or any tCorpus method that supports a subset argument.
}
\examples{
tc = create_tcorpus(c('a a a b b'))

tc$get()
tc$subset(subset = freq_filter(token, min=3))
tc$get()
}
