/* This file is automatically generated. DO NOT EDIT!
   Instead, edit gen-wordbreak.py and re-run.  */

/*
 * Unicode Word_Break property values.
 *
 * Defined in UAX #29 "Unicode Text Segmentation"
 *
 *     http://www.unicode.org/reports/tr29/
 *
 * Section 4.1, Table 3.
 *
 *
 * We use the two-stage lookup strategy described at
 *
 *     http://www.strchr.com/multi-stage_tables
 *
 */

#ifndef WORDBREAKPROP_H
#define WORDBREAKPROP_H

#include <stdint.h>

enum word_break_prop {
	WORD_BREAK_NONE = 0,
	WORD_BREAK_ALETTER = 1,
	WORD_BREAK_CR = 2,
	WORD_BREAK_DOUBLE_QUOTE = 3,
	WORD_BREAK_E_BASE = 4,
	WORD_BREAK_E_BASE_GAZ = 5,
	WORD_BREAK_E_MODIFIER = 6,
	WORD_BREAK_EXTEND = 7,
	WORD_BREAK_EXTENDNUMLET = 8,
	WORD_BREAK_FORMAT = 9,
	WORD_BREAK_GLUE_AFTER_ZWJ = 10,
	WORD_BREAK_HEBREW_LETTER = 11,
	WORD_BREAK_KATAKANA = 12,
	WORD_BREAK_LF = 13,
	WORD_BREAK_LETTER = 14,
	WORD_BREAK_MARK = 15,
	WORD_BREAK_MIDLETTER = 16,
	WORD_BREAK_MIDNUM = 17,
	WORD_BREAK_MIDNUMLET = 18,
	WORD_BREAK_NEWLINE = 19,
	WORD_BREAK_NUMBER = 20,
	WORD_BREAK_NUMERIC = 21,
	WORD_BREAK_OTHER = 22,
	WORD_BREAK_PUNCTUATION = 23,
	WORD_BREAK_REGIONAL_INDICATOR = 24,
	WORD_BREAK_SINGLE_QUOTE = 25,
	WORD_BREAK_SYMBOL = 26,
	WORD_BREAK_WHITE_SPACE = 27,
	WORD_BREAK_ZWJ = 28
};

static const uint8_t word_break_stage1[] = {
/* U+0000 */  0,  1,  2,  2,  2,  3,  4,  5,  2,  6,  7,  8,  9, 10, 11, 12,
/* U+0800 */ 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
/* U+1000 */ 29, 30,  2,  2, 31, 32, 33, 34, 35,  2,  2,  2, 36, 37, 38, 39,
/* U+1800 */ 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,  2, 50,  2,  2, 51, 52,
/* U+2000 */ 53, 54, 55, 56, 57, 57, 58, 59, 60, 61, 57, 57, 62, 63, 64, 65,
/* U+2800 */ 57, 57, 57, 66, 57, 57, 67, 68, 69, 70, 71, 72, 73, 74, 57, 75,
/* U+3000 */ 76, 77, 78, 79, 80, 81, 82, 57, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+3800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+4000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+4800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 84, 83, 83, 83, 83,
/* U+5000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+5800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+6000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+6800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+7000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+7800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+8000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+8800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+9000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+9800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 85,
/* U+A000 */  2,  2,  2,  2,  2,  2,  2,  2,  2, 86,  2,  2, 87, 88, 89, 90,
/* U+A800 */ 91, 92, 93, 94, 95, 96, 97, 98,  2,  2,  2,  2,  2,  2,  2,  2,
/* U+B000 */  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
/* U+B800 */  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
/* U+C000 */  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
/* U+C800 */  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
/* U+D000 */  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 99,
/* U+D800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F800 */100,100, 83, 83,101,102,103,104,  2,  2,105,106,107,108,109,110,
/* U+10000 */111,112,113,114,100,115,116,117,  2,118,119,100,  2,  2,120,100,
/* U+10800 */121,122,123,124,125,126,127,128,129,130,100,100,131,100,100,100,
/* U+11000 */132,133,134,135,136,137,138,100,139,140,100,141,142,143,144,100,
/* U+11800 */100,145,100,100,100,146,100,100,147,148,100,100,100,100,100,100,
/* U+12000 */  2,  2,  2,  2,  2,  2,  2,149,150,  2,151,100,100,100,100,100,
/* U+12800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+13000 */  2,  2,  2,  2,  2,  2,  2,  2,152,100,100,100,100,100,100,100,
/* U+13800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+14000 */100,100,100,100,100,100,100,100,  2,  2,  2,  2,153,100,100,100,
/* U+14800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+15000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+15800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+16000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+16800 */  2,  2,  2,  2,154,155,156,157,100,100,100,100,100,100,158,159,
/* U+17000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+17800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+18000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,160,
/* U+18800 */ 83, 83, 83, 83, 83,161,100,100,100,100,100,100,100,100,100,100,
/* U+19000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+19800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+1A000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+1A800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+1B000 */162,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+1B800 */100,100,100,100,100,100,100,100,163,164,100,100,100,100,100,100,
/* U+1C000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+1C800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+1D000 */ 57,165,166,167,168,100,169,100,170,171,172,  2,  2,173,174,175,
/* U+1D800 */ 57, 57, 57, 57,176,177,100,100,100,100,100,100,100,100,100,100,
/* U+1E000 */178,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+1E800 */  2,179,180,100,100,100,100,100,100,100,100,100,181,182,100,100,
/* U+1F000 */183,184,185,186,187,100, 57,188,189,190,191,192,193,194,195,196,
/* U+1F800 */197,198,199,200,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+20000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+20800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+21000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+21800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+22000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+22800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+23000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+23800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+24000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+24800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+25000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+25800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+26000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+26800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+27000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+27800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+28000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+28800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+29000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+29800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+2A000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,201, 83, 83,
/* U+2A800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+2B000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,202, 83,
/* U+2B800 */203, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+2C000 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
/* U+2C800 */ 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,204,100,100,
/* U+2D000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+2D800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+2E000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+2E800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+2F000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+2F800 */ 83, 83, 83, 83,205,100,100,100,100,100,100,100,100,100,100,100,
/* U+30000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+30800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+31000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+31800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+32000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+32800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+33000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+33800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+34000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+34800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+35000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+35800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+36000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+36800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+37000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+37800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+38000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+38800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+39000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+39800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3A000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3A800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3B000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3B800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3C000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3C800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3D000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3D800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3E000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3E800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3F000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+3F800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+40000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+40800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+41000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+41800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+42000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+42800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+43000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+43800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+44000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+44800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+45000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+45800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+46000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+46800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+47000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+47800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+48000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+48800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+49000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+49800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4A000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4A800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4B000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4B800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4C000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4C800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4D000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4D800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4E000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4E800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4F000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+4F800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+50000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+50800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+51000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+51800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+52000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+52800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+53000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+53800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+54000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+54800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+55000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+55800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+56000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+56800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+57000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+57800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+58000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+58800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+59000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+59800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5A000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5A800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5B000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5B800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5C000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5C800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5D000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5D800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5E000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5E800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5F000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+5F800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+60000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+60800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+61000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+61800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+62000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+62800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+63000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+63800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+64000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+64800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+65000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+65800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+66000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+66800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+67000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+67800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+68000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+68800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+69000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+69800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6A000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6A800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6B000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6B800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6C000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6C800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6D000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6D800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6E000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6E800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6F000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+6F800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+70000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+70800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+71000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+71800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+72000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+72800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+73000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+73800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+74000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+74800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+75000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+75800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+76000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+76800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+77000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+77800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+78000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+78800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+79000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+79800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7A000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7A800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7B000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7B800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7C000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7C800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7D000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7D800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7E000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7E800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7F000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+7F800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+80000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+80800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+81000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+81800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+82000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+82800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+83000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+83800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+84000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+84800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+85000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+85800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+86000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+86800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+87000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+87800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+88000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+88800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+89000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+89800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8A000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8A800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8B000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8B800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8C000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8C800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8D000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8D800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8E000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8E800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8F000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+8F800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+90000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+90800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+91000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+91800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+92000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+92800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+93000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+93800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+94000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+94800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+95000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+95800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+96000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+96800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+97000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+97800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+98000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+98800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+99000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+99800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9A000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9A800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9B000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9B800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9C000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9C800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9D000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9D800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9E000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9E800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9F000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+9F800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A0000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A0800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A1000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A1800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A2000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A2800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A3000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A3800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A4000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A4800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A5000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A5800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A6000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A6800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A7000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A7800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A8000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A8800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A9000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+A9800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AA000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AA800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AB000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AB800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AC000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AC800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AD000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AD800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AE000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AE800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AF000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+AF800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B0000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B0800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B1000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B1800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B2000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B2800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B3000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B3800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B4000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B4800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B5000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B5800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B6000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B6800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B7000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B7800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B8000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B8800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B9000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+B9800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BA000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BA800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BB000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BB800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BC000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BC800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BD000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BD800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BE000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BE800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BF000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+BF800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C0000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C0800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C1000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C1800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C2000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C2800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C3000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C3800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C4000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C4800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C5000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C5800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C6000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C6800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C7000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C7800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C8000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C8800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C9000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+C9800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CA000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CA800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CB000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CB800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CC000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CC800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CD000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CD800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CE000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CE800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CF000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+CF800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D0000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D0800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D1000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D1800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D2000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D2800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D3000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D3800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D4000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D4800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D5000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D5800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D6000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D6800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D7000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D7800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D8000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D8800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D9000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+D9800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DA000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DA800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DB000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DB800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DC000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DC800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DD000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DD800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DE000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DE800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DF000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+DF800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E0000 */206,207,208,209,207,207,207,207,207,207,207,207,207,207,207,207,
/* U+E0800 */207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,
/* U+E1000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E1800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E2000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E2800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E3000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E3800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E4000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E4800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E5000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E5800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E6000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E6800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E7000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E7800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E8000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E8800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E9000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+E9800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+EA000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+EA800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+EB000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+EB800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+EC000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+EC800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+ED000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+ED800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+EE000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+EE800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+EF000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+EF800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F0000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F0800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F1000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F1800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F2000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F2800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F3000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F3800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F4000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F4800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F5000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F5800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F6000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F6800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F7000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F7800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F8000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F8800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F9000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+F9800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FA000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FA800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FB000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FB800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FC000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FC800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FD000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FD800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FE000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FE800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FF000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+FF800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+100000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+100800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+101000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+101800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+102000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+102800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+103000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+103800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+104000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+104800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+105000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+105800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+106000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+106800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+107000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+107800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+108000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+108800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+109000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+109800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10A000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10A800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10B000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10B800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10C000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10C800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10D000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10D800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10E000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10E800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10F000 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
/* U+10F800 */100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100
};

static const int8_t word_break_stage2[][128] = {
  /* block 0 */
  { 22, 22, 22, 22, 22, 22, 22, 22, 22, 27, 13, 19, 19,  2, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    27, 23,  3, 23, 26, 23, 23, 25, 23, 23, 23, 26, 17, 23, 18, 23,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 16, 17, 26, 26, 26, 23,
    23,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 23, 23, 15,  8,
    15,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 26, 23, 26, 22
  },

  /* block 1 */
  { 22, 22, 22, 22, 22, 19, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    27, 23, 26, 26, 26, 26, 26, 23, 15, 26,  1, 23, 26,  9, 26, 15,
    26, 26, 20, 20, 15,  1, 23, 16, 15, 20,  1, 23, 20, 20, 20, 23,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, 26,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, 26,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 2 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 3 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1, 15, 15, 15, 15,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1, 15, 15, 15, 15, 15, 16, 15, 15, 15, 15, 15, 15, 15, 15,
     1,  1,  1,  1,  1, 15, 15, 15, 15, 15, 15, 15,  1, 15,  1, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15
  },

  /* block 4 */
  {  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     1,  1,  1,  1,  1, 15,  1,  1, 22, 22,  1,  1,  1,  1, 17,  1
  },

  /* block 5 */
  { 22, 22, 22, 22, 15, 15,  1, 16,  1,  1,  1, 22,  1, 22,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 26,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 6 */
  {  1,  1, 26,  7,  7,  7,  7,  7,  7,  7,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 7 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, 22, 22,  1, 23, 23, 23, 23, 23, 23,
    22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 8 */
  {  1,  1,  1,  1,  1,  1,  1,  1, 22, 17, 23, 22, 22, 26, 26, 26,
    22,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 23,  7,
    23,  7,  7, 23,  7,  7, 23,  7, 22, 22, 22, 22, 22, 22, 22, 22,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 22, 22, 22, 22, 22,
    11, 11, 11,  1, 16, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 9 */
  {  9,  9,  9,  9,  9,  9, 26, 26, 26, 23, 23, 26, 17, 17, 26, 26,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 23,  9, 22, 23, 23,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 23, 21, 17, 23,  1,  1,
     7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 10 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 23,  1,  7,  7,  7,  7,  7,  7,  7,  9, 26,  7,
     7,  7,  7,  7,  7,  1,  1,  7,  7, 26,  7,  7,  7,  7,  1,  1,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21,  1,  1,  1, 26, 26,  1
  },

  /* block 11 */
  { 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 22,  9,
     1,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 22, 22,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 12 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  1,  1, 26, 23, 17, 23,  1, 22, 22, 22, 22, 22
  },

  /* block 13 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  1,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  1,  7,  7,  7,  1,  7,  7,  7,  7,  7, 22, 22,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  7,  7, 22, 22, 23, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 14 */
  { 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  9,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7
  },

  /* block 15 */
  {  7,  7,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  7,  7,  1,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     1,  7,  7,  7,  7,  7,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  7,  7, 23, 23, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    23,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 16 */
  {  1,  7,  7,  7, 22,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,  1,
     1, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,
     1, 22,  1, 22, 22, 22,  1,  1,  1,  1, 22, 22,  7,  1,  7,  7,
     7,  7,  7,  7,  7, 22, 22,  7,  7, 22, 22,  7,  7,  7,  1, 22,
    22, 22, 22, 22, 22, 22, 22,  7, 22, 22, 22, 22,  1,  1, 22,  1,
     1,  1,  7,  7, 22, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
     1,  1, 26, 26, 20, 20, 20, 20, 20, 20, 26, 26, 22, 22, 22, 22
  },

  /* block 17 */
  { 22,  7,  7,  7, 22,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22,  1,
     1, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,
     1, 22,  1,  1, 22,  1,  1, 22,  1,  1, 22, 22,  7, 22,  7,  7,
     7,  7,  7, 22, 22, 22, 22,  7,  7, 22, 22,  7,  7,  7, 22, 22,
    22,  7, 22, 22, 22, 22, 22, 22, 22,  1,  1,  1,  1, 22,  1, 22,
    22, 22, 22, 22, 22, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
     7,  7,  1,  1,  1,  7, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 18 */
  { 22,  7,  7,  7, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,
     1,  1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,
     1, 22,  1,  1, 22,  1,  1,  1,  1,  1, 22, 22,  7,  1,  7,  7,
     7,  7,  7,  7,  7,  7, 22,  7,  7,  7, 22,  7,  7,  7, 22, 22,
     1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  7,  7, 22, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    23, 26, 22, 22, 22, 22, 22, 22, 22,  1, 22, 22, 22, 22, 22, 22
  },

  /* block 19 */
  { 22,  7,  7,  7, 22,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,  1,
     1, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,
     1, 22,  1,  1, 22,  1,  1,  1,  1,  1, 22, 22,  7,  1,  7,  7,
     7,  7,  7,  7,  7, 22, 22,  7,  7, 22, 22,  7,  7,  7, 22, 22,
    22, 22, 22, 22, 22, 22,  7,  7, 22, 22, 22, 22,  1,  1, 22,  1,
     1,  1,  7,  7, 22, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    26,  1, 20, 20, 20, 20, 20, 20, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 20 */
  { 22, 22,  7,  1, 22,  1,  1,  1,  1,  1,  1, 22, 22, 22,  1,  1,
     1, 22,  1,  1,  1,  1, 22, 22, 22,  1,  1, 22,  1, 22,  1,  1,
    22, 22, 22,  1,  1, 22, 22, 22,  1,  1,  1, 22, 22, 22,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22,  7,  7,
     7,  7,  7, 22, 22, 22,  7,  7,  7, 22,  7,  7,  7,  7, 22, 22,
     1, 22, 22, 22, 22, 22, 22,  7, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    20, 20, 20, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22
  },

  /* block 21 */
  {  7,  7,  7,  7, 22,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,
     1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22,  1,  7,  7,
     7,  7,  7,  7,  7, 22,  7,  7,  7, 22,  7,  7,  7,  7, 22, 22,
    22, 22, 22, 22, 22,  7,  7, 22,  1,  1,  1, 22, 22, 22, 22, 22,
     1,  1,  7,  7, 22, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    22, 22, 22, 22, 22, 22, 22, 22, 20, 20, 20, 20, 20, 20, 20, 26
  },

  /* block 22 */
  {  1,  7,  7,  7, 22,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,
     1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 22,  1,  1,  1,  1,  1, 22, 22,  7,  1,  7,  7,
     7,  7,  7,  7,  7, 22,  7,  7,  7, 22,  7,  7,  7,  7, 22, 22,
    22, 22, 22, 22, 22,  7,  7, 22, 22, 22, 22, 22, 22, 22,  1, 22,
     1,  1,  7,  7, 22, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    22,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 23 */
  { 22,  7,  7,  7, 22,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,
     1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,  1,  7,  7,
     7,  7,  7,  7,  7, 22,  7,  7,  7, 22,  7,  7,  7,  7,  1, 26,
    22, 22, 22, 22,  1,  1,  1,  7, 20, 20, 20, 20, 20, 20, 20,  1,
     1,  1,  7,  7, 22, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 26,  1,  1,  1,  1,  1,  1
  },

  /* block 24 */
  { 22, 22,  7,  7, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, 22, 22, 22,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1, 22, 22,
     1,  1,  1,  1,  1,  1,  1, 22, 22, 22,  7, 22, 22, 22, 22,  7,
     7,  7,  7,  7,  7, 22,  7, 22,  7,  7,  7,  7,  7,  7,  7,  7,
    22, 22, 22, 22, 22, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    22, 22,  7,  7, 23, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 25 */
  { 22, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14,  7, 14, 14,  7,  7,  7,  7,  7,  7,  7, 22, 22, 22, 22, 26,
    14, 14, 14, 14, 14, 14, 14,  7,  7,  7,  7,  7,  7,  7,  7, 23,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 23, 23, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 26 */
  { 22, 14, 14, 22, 14, 22, 22, 14, 14, 22, 14, 22, 22, 14, 22, 22,
    22, 22, 22, 22, 14, 14, 14, 14, 22, 14, 14, 14, 14, 14, 14, 14,
    22, 14, 14, 14, 22, 14, 22, 14, 22, 22, 14, 14, 22, 14, 14, 14,
    14,  7, 14, 14,  7,  7,  7,  7,  7,  7, 22,  7,  7, 14, 22, 22,
    14, 14, 14, 14, 14, 22, 14, 22,  7,  7,  7,  7,  7,  7, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 14, 14, 14, 14,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 27 */
  {  1, 26, 26, 26, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 26, 23, 26, 26, 26,  7,  7, 26, 26, 26, 26, 26, 26,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 26,  7, 26,  7, 26,  7, 23, 23, 23, 23,  7,  7,
     1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22,
    22,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7
  },

  /* block 28 */
  {  7,  7,  7,  7,  7, 23,  7,  7,  1,  1,  1,  1,  1,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7, 22,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 22, 26, 26,
    26, 26, 26, 26, 26, 26,  7, 26, 26, 26, 26, 26, 26, 22, 26, 26,
    23, 23, 23, 23, 23, 26, 26, 26, 26, 23, 23, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 29 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 14,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 23, 23, 23, 23, 23, 23,
    14, 14, 14, 14, 14, 14,  7,  7,  7,  7, 14, 14, 14, 14,  7,  7,
     7, 14,  7,  7,  7, 14, 14,  7,  7,  7,  7,  7,  7,  7, 14, 14,
    14,  7,  7,  7,  7, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14
  },

  /* block 30 */
  { 14, 14,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 14,  7,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21,  7,  7,  7,  7, 26, 26,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22,  1, 22, 22, 22, 22, 22,  1, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23,  1,  1,  1,  1
  },

  /* block 31 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1, 22, 22,
     1,  1,  1,  1,  1,  1,  1, 22,  1, 22,  1,  1,  1,  1, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 32 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1, 22,  1,  1,  1,  1, 22, 22,  1,  1,  1,  1,  1,  1,  1, 22,
     1, 22,  1,  1,  1,  1, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 33 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1, 22,  1,  1,  1,  1, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,  7,  7,  7,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 22, 22, 22
  },

  /* block 34 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22, 22,  1,  1,  1,  1,  1,  1, 22, 22
  },

  /* block 35 */
  { 23,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 36 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 23,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 37 */
  { 27,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 23, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 23, 23,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 38 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,
     1,  1,  7,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  7,  7,  7, 23, 23, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,
     1, 22,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 39 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7, 23, 23, 23, 14, 23, 23, 23, 26, 14,  7, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 22, 22, 22, 22, 22, 22
  },

  /* block 40 */
  { 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,  7,  7,  7,  9, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 41 */
  {  1,  1,  1,  1,  1,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  1, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 42 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 22, 22, 22, 22,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 22, 22, 22, 22,
    26, 22, 22, 22, 23, 23, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 22, 22,
    14, 14, 14, 14, 14, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 43 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 22, 22, 22, 22,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 22, 22, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 22, 22, 22, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 44 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7, 22, 22, 23, 23,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 22,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 22, 22,  7
  },

  /* block 45 */
  { 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
    23, 23, 23, 23, 23, 23, 23, 14, 23, 23, 23, 23, 23, 23, 22, 22,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 46 */
  {  7,  7,  7,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 23, 23, 23, 23, 23, 23,
    23, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,  7,  7,  7,  7,  7,
     7,  7,  7,  7, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22
  },

  /* block 47 */
  {  7,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  1,  1,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23
  },

  /* block 48 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7, 22, 22, 22, 23, 23, 23, 23, 23,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22,  1,  1,  1,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 23
  },

  /* block 49 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    23, 23, 23, 23, 23, 23, 23, 23, 22, 22, 22, 22, 22, 22, 22, 22,
     7,  7,  7, 23,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  1,  1,  1,  1,  7,  1,  1,
     1,  1,  7,  7,  7,  1,  1, 22,  7,  7, 22, 22, 22, 22, 22, 22
  },

  /* block 50 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7, 22, 22, 22, 22, 22,  7,  7,  7,  7,  7
  },

  /* block 51 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22, 22,  1,  1,  1,  1,  1,  1, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22, 22,  1,  1,  1,  1,  1,  1, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1, 22,  1, 22,  1, 22,  1, 22,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22
  },

  /* block 52 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1, 15,  1, 15,
    15, 15,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1, 15, 15, 15,
     1,  1,  1,  1, 22, 22,  1,  1,  1,  1,  1,  1, 22, 15, 15, 15,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 15, 15, 15,
    22, 22,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1, 15, 15, 22
  },

  /* block 53 */
  { 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,  7, 28,  9,  9,
    23, 23, 23, 23, 23, 23, 23, 23, 18, 18, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 23, 18, 23, 23, 16, 19, 19,  9,  9,  9,  9,  9,  8,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,  8,
     8, 23, 23, 23, 17, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 26, 23,  8, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 27,
     9,  9,  9,  9,  9, 27,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
    20,  1, 22, 22, 20, 20, 20, 20, 20, 20, 26, 26, 26, 23, 23,  1
  },

  /* block 54 */
  { 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 26, 26, 26, 23, 23, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 55 */
  { 26, 26,  1, 26, 26, 26, 26,  1, 26, 26,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 26,  1, 26, 26, 26,  1,  1,  1,  1,  1, 26, 26,
    26, 26, 26, 26,  1, 26,  1, 26,  1, 26,  1,  1,  1,  1, 26,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26, 26,  1,  1,  1,  1,
    26, 26, 26, 26, 26,  1,  1,  1,  1,  1, 26, 26, 26, 26,  1, 26,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 56 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1, 20, 26, 26, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 57 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 58 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 23, 23, 23, 23, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 23, 23, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 59 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22
  },

  /* block 60 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
  },

  /* block 61 */
  { 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
  },

  /* block 62 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,  4, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 63 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26,  4, 26, 26, 26, 26, 26, 26
  },

  /* block 64 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,  4,  4,  4,  4, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 10, 26, 26, 26, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 23, 23, 23, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
  },

  /* block 65 */
  { 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 23, 23, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 66 */
  { 26, 26, 26, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 23, 23, 23, 23, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 23, 23, 26, 26
  },

  /* block 67 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 22, 22, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 68 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 22, 22, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 26, 26, 26, 26, 26, 26,
    26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 26, 26, 26, 26,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 69 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 70 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1, 26, 26, 26, 26, 26, 26,  1,  1,  1,  1,  7,
     7,  7,  1,  1, 22, 22, 22, 22, 22, 23, 23, 23, 23, 20, 23, 23
  },

  /* block 71 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22,  1, 22, 22, 22, 22, 22,  1, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22,  1,
    23, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,  7
  },

  /* block 72 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1, 22,
     1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1, 22,
     1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1, 22,
     1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1, 22,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7
  },

  /* block 73 */
  { 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,  1,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 23, 23, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 74 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 75 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22
  },

  /* block 76 */
  { 27, 23, 23, 23, 26,  1, 14, 14, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 26, 26, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    26, 14, 14, 14, 14, 14, 14, 14, 14, 14,  7,  7,  7,  7,  7,  7,
    23, 12, 12, 12, 12, 12, 26, 26, 14, 14, 14,  1,  1, 23, 26, 26,
    22, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14
  },

  /* block 77 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 22, 22,  7,  7, 12, 12, 14, 14, 14,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 23, 12, 12, 12, 12
  },

  /* block 78 */
  { 22, 22, 22, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,
    22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 79 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,
    26, 26, 20, 20, 20, 20, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12
  },

  /* block 80 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 20, 20, 20, 20, 20, 20, 20, 20,
    26, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 81 */
  { 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 22
  },

  /* block 82 */
  { 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 83 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14
  },

  /* block 84 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 85 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 86 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 23
  },

  /* block 87 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 23, 23,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21,  1,  1, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,
     7,  7,  7, 23,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 23,  1
  },

  /* block 88 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  7,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     7,  7, 23, 23, 23, 23, 23, 23, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 89 */
  { 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    15, 15,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 90 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1, 15, 15,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,
     1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 91 */
  {  1,  1,  7,  1,  1,  1,  7,  1,  1,  1,  1,  7,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  7,  7,  7,  7,  7, 26, 26, 26, 26, 22, 22, 22, 22,
    20, 20, 20, 20, 20, 20, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 23, 23, 23, 23, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 92 */
  {  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  1,  1,  1,  1,  1,  1, 23, 23, 23,  1, 23,  1, 22, 22
  },

  /* block 93 */
  { 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7, 23, 23,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22
  },

  /* block 94 */
  {  7,  7,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 22,  1,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23,
    14, 14, 14, 14, 14,  7, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 14, 14, 14, 14, 14, 22
  },

  /* block 95 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  7,  1,  1,  1,  1,  1,  1,  1,  1,  7,  7, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 23, 23, 23, 23,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 26, 26, 26, 14,  7,  7,  7, 14, 14
  },

  /* block 96 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
     7, 14,  7,  7,  7, 14, 14,  7,  7, 14, 14, 14, 14, 14,  7,  7,
    14,  7, 14, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 14, 14, 14, 23, 23,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7,
    23, 23,  1,  1,  1,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 97 */
  { 22,  1,  1,  1,  1,  1,  1, 22, 22,  1,  1,  1,  1,  1,  1, 22,
    22,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 15,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 98 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7, 23,  7,  7, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22
  },

  /* block 99 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22
  },

  /* block 100 */
  { 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 101 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 22, 22,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14
  },

  /* block 102 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 103 */
  {  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 11,  7, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 26, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 22, 11, 11, 11, 11, 11, 22, 11, 22,
    11, 11, 22, 11, 11, 22, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 104 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 105 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 23,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 106 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    22, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26, 26, 22, 22
  },

  /* block 107 */
  {  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
    17, 23, 23, 16, 17, 23, 23, 23, 23, 23, 22, 22, 22, 22, 22, 22,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
    23, 23, 23,  8,  8, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,  8,  8,  8,
    17, 23, 18, 22, 17, 16, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 26, 23, 26, 26, 26, 22, 23, 26, 23, 23, 22, 22, 22, 22,
     1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 108 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,  9
  },

  /* block 109 */
  { 22, 23, 23, 23, 26, 23, 23, 18, 23, 23, 23, 26, 17, 23, 18, 23,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 16, 17, 26, 26, 26, 23,
    23,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 23, 23, 15,  8,
    15,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 26, 23, 26, 23,
    23, 23, 23, 23, 23, 23, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12
  },

  /* block 110 */
  { 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  7,  7,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,
    22, 22,  1,  1,  1,  1,  1,  1, 22, 22,  1,  1,  1,  1,  1,  1,
    22, 22,  1,  1,  1,  1,  1,  1, 22, 22,  1,  1,  1, 22, 22, 22,
    26, 26, 26, 15, 26, 26, 26, 22, 26, 26, 26, 26, 26, 26, 26, 22,
    27, 27, 27, 27, 27, 27, 27, 27, 27,  9,  9,  9, 26, 26, 22, 22
  },

  /* block 111 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1, 22,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 112 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22
  },

  /* block 113 */
  { 23, 23, 23, 22, 22, 22, 22, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 22, 22, 22, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1, 20, 20, 20, 20, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 114 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 20, 20, 26, 26, 26, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22,
    26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,  7, 22, 22
  },

  /* block 115 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     7, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 22, 22, 22, 22
  },

  /* block 116 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    20, 20, 20, 20, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7, 22, 22, 22, 22, 22
  },

  /* block 117 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 23,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 22, 22, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,
    23,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 118 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 22, 22, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22
  },

  /* block 119 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 120 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 121 */
  {  1,  1,  1,  1,  1,  1, 22, 22,  1, 22,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22,  1,  1, 22, 22, 22,  1, 22, 22,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22, 23, 20, 20, 20, 20, 20, 20, 20, 20,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, 26, 26, 20, 20, 20, 20, 20, 20, 20
  },

  /* block 122 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,
    22, 22, 22, 22, 22, 22, 22, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1, 22,  1,  1, 22, 22, 22, 22, 22, 20, 20, 20, 20, 20
  },

  /* block 123 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 20, 20, 20, 20, 20, 20, 22, 22, 22, 23,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 23,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 124 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 20, 20,  1,  1,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    22, 22, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
  },

  /* block 125 */
  {  1,  7,  7,  7, 22,  7,  7, 22, 22, 22, 22, 22,  7,  7,  7,  7,
     1,  1,  1,  1, 22,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 22, 22, 22, 22,  7,  7,  7, 22, 22, 22, 22,  7,
    20, 20, 20, 20, 20, 20, 20, 20, 22, 22, 22, 22, 22, 22, 22, 22,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20, 20, 23
  },

  /* block 126 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 20, 20, 20,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1, 26,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  7,  7, 22, 22, 22, 22, 20, 20, 20, 20, 20,
    23, 23, 23, 23, 23, 23, 23, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 127 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22, 22, 20, 20, 20, 20, 20, 20, 20, 20,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1, 22, 22, 22, 22, 22, 20, 20, 20, 20, 20, 20, 20, 20
  },

  /* block 128 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 20, 20, 20, 20, 20, 20, 20,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 129 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 130 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 20, 20, 20, 20, 20, 20
  },

  /* block 131 */
  { 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 22
  },

  /* block 132 */
  {  7,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7, 23, 23, 23, 23, 23, 23, 23, 22, 22,
    22, 22, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,  7
  },

  /* block 133 */
  {  7,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 23, 23,  9, 23, 23,
    23, 23, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22
  },

  /* block 134 */
  {  7,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    23, 23, 23, 23, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  7, 23, 23,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 135 */
  {  7,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  1,  1,  1,  1, 23, 23, 23, 23, 23,  7,  7,  7, 23, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21,  1, 23,  1, 23, 23, 23,
    22, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 136 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7, 23, 23, 23, 23, 23, 23,  7, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 137 */
  {  1,  1,  1,  1,  1,  1,  1, 22,  1, 22,  1,  1,  1,  1, 22,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 23, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 22, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22
  },

  /* block 138 */
  {  7,  7,  7,  7, 22,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,  1,
     1, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,
     1, 22,  1,  1, 22,  1,  1,  1,  1,  1, 22, 22,  7,  1,  7,  7,
     7,  7,  7,  7,  7, 22, 22,  7,  7, 22, 22,  7,  7,  7, 22, 22,
     1, 22, 22, 22, 22, 22, 22,  7, 22, 22, 22, 22, 22,  1,  1,  1,
     1,  1,  7,  7, 22, 22,  7,  7,  7,  7,  7,  7,  7, 22, 22, 22,
     7,  7,  7,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 139 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  1,  1,  1,  1, 23, 23, 23, 23, 23,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 23, 22, 23, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 140 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  1,  1, 23,  1, 22, 22, 22, 22, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 141 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,
     7,  7,  7,  7,  7,  7, 22, 22,  7,  7,  7,  7,  7,  7,  7,  7,
     7, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 23, 23, 23, 23, 23,  1,  1,  1,  1,  7,  7, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 142 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7, 23, 23, 23,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 143 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 144 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 22, 22, 22,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20, 23, 23, 23, 26,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 145 */
  { 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,  1
  },

  /* block 146 */
  { 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 147 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,
     7,  7,  7,  7,  7,  7,  7, 22,  7,  7,  7,  7,  7,  7,  7,  7,
     1, 23, 23, 23, 23, 23, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 22, 22, 22,
    23, 23,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 148 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    22, 22,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7, 22,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 149 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 150 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,
    23, 23, 23, 23, 23, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 151 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 152 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 153 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 154 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 155 */
  { 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22,
     7,  7,  7,  7,  7, 23, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 156 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     7,  7,  7,  7,  7,  7,  7, 23, 23, 23, 23, 23, 26, 26, 26, 26,
     1,  1,  1,  1, 23, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 20, 20, 20, 20, 20,
    20, 20, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22,  1,  1,  1
  },

  /* block 157 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 158 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 22
  },

  /* block 159 */
  { 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,  7,
     7,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
     1, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 160 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 161 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 162 */
  { 12, 14, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 163 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22
  },

  /* block 164 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 26,  7,  7, 23,
     9,  9,  9,  9, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 165 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 166 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 22, 22, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26,  7,  7,  7,  7,  7, 26, 26, 26,  7,  7,  7,
     7,  7,  7,  9,  9,  9,  9,  9,  9,  9,  9,  7,  7,  7,  7,  7
  },

  /* block 167 */
  {  7,  7,  7, 26, 26,  7,  7,  7,  7,  7,  7,  7, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26,  7,  7,  7,  7, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 168 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26,  7,  7,  7, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 169 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 170 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 171 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,
    22, 22,  1, 22, 22,  1,  1, 22, 22,  1,  1,  1,  1, 22,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1, 22,  1,  1,  1,
     1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 172 */
  {  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1, 22, 22,  1,  1,  1,
     1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1, 22,
     1,  1,  1,  1,  1, 22,  1, 22, 22, 22,  1,  1,  1,  1,  1,  1,
     1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 173 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1, 22, 22,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1, 26,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26,  1,  1,  1,  1
  },

  /* block 174 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1, 26,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1, 26,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 175 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1, 26,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1, 26,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1, 26,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 21, 21,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21
  },

  /* block 176 */
  {  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7, 26, 26, 26, 26,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 26, 26, 26,
    26, 26, 26, 26, 26,  7, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 177 */
  { 26, 26, 26, 26,  7, 26, 26, 23, 23, 23, 23, 23, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,  7,  7,  7,  7,  7,
    22,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 178 */
  {  7,  7,  7,  7,  7,  7,  7, 22,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7, 22, 22,  7,  7,  7,  7,  7,
     7,  7, 22,  7,  7, 22,  7,  7,  7,  7,  7, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 179 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1, 22, 22, 20, 20, 20, 20, 20, 20, 20, 20, 20,
     7,  7,  7,  7,  7,  7,  7, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 180 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  7,  7,  7,  7,  7,  7,  7, 22, 22, 22, 22, 22,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 181 */
  {  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    22,  1,  1, 22,  1, 22, 22,  1, 22,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1, 22,  1,  1,  1,  1, 22,  1, 22,  1, 22, 22, 22, 22,
    22, 22,  1, 22, 22, 22, 22,  1, 22,  1, 22,  1, 22,  1,  1,  1,
    22,  1,  1, 22,  1, 22, 22,  1, 22,  1, 22,  1, 22,  1, 22,  1,
    22,  1,  1, 22,  1, 22, 22,  1,  1,  1,  1, 22,  1,  1,  1,  1,
     1,  1,  1, 22,  1,  1,  1,  1, 22,  1,  1,  1,  1, 22,  1, 22
  },

  /* block 182 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22,
    22,  1,  1,  1, 22,  1,  1,  1,  1,  1, 22,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 183 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 184 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22,
    22, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    22, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    22, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 185 */
  { 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26, 26, 26, 26, 26, 26,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26, 26, 22, 22, 22, 22,
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1
  },

  /* block 186 */
  {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24
  },

  /* block 187 */
  { 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 188 */
  { 26, 26, 26, 26, 26,  4, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26,  4,  4, 26, 26, 26, 26, 26,  4,  4, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,  6,  6,  6,  6,  6
  },

  /* block 189 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26,  4,  4, 26, 26,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
     4, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26,  5,  5,  5,  5, 26, 26, 26, 26,  4, 26,
     4,  4,  4,  4,  4,  4,  4,  4,  4, 26, 26, 26,  4, 26, 26, 26
  },

  /* block 190 */
  { 26,  4,  4,  4, 26,  4,  4,  4, 26, 26, 26, 10, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26,  4, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 191 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26,  4, 26, 26, 26, 26,  4, 26, 26, 26, 26, 26
  },

  /* block 192 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     4, 26, 26, 26, 26,  4,  4, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 10, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 193 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26,  4,  4,  4, 26, 26, 26,  4,  4,  4,  4,  4,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 194 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26,  4, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26,  4,  4,  4, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     4, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 195 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 196 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 197 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26
  },

  /* block 198 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 199 */
  { 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26,  4,  4,  4,  4,  4,  4,  4, 22,
    26, 26, 26, 26, 26, 26,  4, 26, 22, 22, 22, 22, 22, 22, 22, 22,
     4, 22, 22,  4,  4,  4,  4,  4,  4,  4, 26, 26,  4,  4,  4, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22, 22, 22, 22,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 200 */
  { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    26, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 201 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 202 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14
  },

  /* block 203 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 22, 22,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14
  },

  /* block 204 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 205 */
  { 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22
  },

  /* block 206 */
  { 27,  9, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7
  },

  /* block 207 */
  { 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27
  },

  /* block 208 */
  {  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7
  },

  /* block 209 */
  {  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27
  }
};

static int word_break(uint32_t code)
{
	const uint32_t block_size = 128;
	uint8_t i = word_break_stage1[code / block_size];
	return word_break_stage2[i][code % block_size];
}

#endif /* WORDBREAKPROP_H */
