% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbetabinom.R
\name{qbetabinom}
\alias{qbetabinom}
\title{Get quantiles of beta binom}
\usage{
qbetabinom(p, M, mu, phi)
}
\arguments{
\item{p}{Numeric. Probability for quantile}

\item{M}{Numeric vector of sequencing depth}

\item{mu}{Numeric vector of abundance parameter}

\item{phi}{Numeric vector of dispersion parameter}
}
\value{
quantile
}
\description{
Get quantiles of beta binom
}
\examples{
data(soil_phylum_small)
mod <- bbdml(formula = OTU.1 ~ DayAmdmt,
phi.formula = ~ DayAmdmt,
data = soil_phylum_small)
qbetabinom(.5, M = mod$M[1], mu = mod$mu.resp[1], phi = mod$phi.resp[1])
}
