/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data.feature;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uno.informatics.common.ConversionUtilities;
import uno.informatics.common.io.IOUtilities;
import uno.informatics.common.io.RowReader;
import uno.informatics.data.Dataset;
import uno.informatics.data.Feature;
import uno.informatics.data.dataset.FeatureData;
import uno.informatics.data.dataset.FeatureDataRow;
import uno.informatics.data.feature.ColumnFeature;
import uno.informatics.data.io.FileType;
import uno.informatics.data.pojo.SimpleEntityPojo;
import uno.informatics.data.utils.DataOption;
import uno.informatics.data.utils.DatasetUtils;

public abstract class AbstractFeatureData
extends SimpleEntityPojo
implements FeatureData {
    private static final long serialVersionUID = 1L;
    private static final int INVALID_ROW_COUNT = -1;
    public static final String ID = "ID";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String TYPE = "TYPE";
    public static final String MIN = "MIN";
    public static final String MAX = "MAX";
    private List<Feature> features;
    private Dataset dataset;

    protected AbstractFeatureData(String name, List<? extends Feature> features) {
        super(null, name);
        this.setFeatures(features);
    }

    protected AbstractFeatureData(String uniqueIdentifier, String name, List<? extends Feature> features) {
        super(uniqueIdentifier, name);
        this.setFeatures(features);
    }

    protected AbstractFeatureData(String name, Feature[] features) {
        super(null, name);
        this.setFeatures(features);
    }

    protected AbstractFeatureData(String uniqueIdentifier, String name, Feature[] features) {
        super(uniqueIdentifier, name);
        this.setFeatures(features);
    }

    @Override
    public final List<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public Feature[] getFeaturesAsArray() {
        return this.features.toArray(new Feature[this.features.size()]);
    }

    @Override
    public abstract int getRowCount();

    @Override
    public abstract FeatureDataRow[] getRowsAsArray();

    @Override
    public abstract List<FeatureDataRow> getRows();

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    protected final void setFeatures(List<? extends Feature> features) {
        this.features = new ArrayList<Feature>();
        this.features.addAll(features);
    }

    protected final void setFeatures(Feature[] features) {
        this.features = new ArrayList<Feature>();
        for (int i = 0; i < features.length; ++i) {
            this.features.add(features[i]);
        }
    }

    public static final List<ColumnFeature> generateDatasetFeatures(Path path, FileType fileType, String columnLabel, DataOption ... options) throws IOException {
        return AbstractFeatureData.generateDatasetFeatures(path, fileType, columnLabel, -1, options);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final List<ColumnFeature> generateDatasetFeatures(Path filePath, FileType type, String columnLabel, int numRows, DataOption ... options) throws IOException {
        RowReader reader = null;
        ArrayList<ColumnFeature> features = null;
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (!filePath.toFile().exists()) {
            throw new IOException("File does not exist : " + filePath + ".");
        }
        if (type == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (type != FileType.TXT && type != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{type}));
        }
        String uniqueIdentifier = DataOption.findValue(options, ID, String.class);
        reader = IOUtilities.createRowReader(filePath, type, new int[0]);
        if (reader != null && reader.ready()) {
            void var10_15;
            features = new ArrayList<ColumnFeature>();
            List<String> colIds = null;
            List<String> colNames = null;
            ArrayList arrayList = new ArrayList();
            int columnCount = 0;
            int row = 0;
            int rowsRead = 0;
            String rowID = null;
            boolean hasRowNames = false;
            if (reader.nextRow()) {
                colIds = reader.getRowCellsAsString();
                if (ID.equals(colIds.get(0))) {
                    if (colIds.size() > 1 && NAME.equals(colIds.get(1))) {
                        colIds.remove(0);
                        colIds.remove(0);
                        hasRowNames = true;
                    } else {
                        colIds.remove(0);
                    }
                } else {
                    if (uniqueIdentifier != null) {
                        throw new IllegalArgumentException("Using ID DataOption: First cell must be ID");
                    }
                    colIds.remove(0);
                }
                columnCount = colIds.size();
                ++row;
                if (!reader.nextRow()) throw new IOException("No enough rows");
                reader.nextColumn();
                rowID = reader.getCellAsString();
                if (hasRowNames) {
                    reader.nextColumn();
                }
                reader.nextColumn();
                List<String> cells = reader.getRowCellsAsString();
                ++row;
                ++rowsRead;
                boolean hasColNames = NAME.equals(rowID);
                if (hasColNames) {
                    if (!reader.nextRow()) throw new IOException("Not enough rows");
                    reader.nextColumn();
                    colNames = cells;
                    if (hasRowNames) {
                        reader.nextColumn();
                    }
                    reader.nextColumn();
                    ++row;
                    ++rowsRead;
                } else {
                    colNames = colIds;
                }
                cells = reader.getRowCellsAsString();
                List<Integer> list = ConversionUtilities.getDataTypes(cells);
                features = new ArrayList(columnCount);
                List<Integer> list2 = ConversionUtilities.getDataTypes(cells);
                while (reader.nextRow() && (numRows < 0 || rowsRead < numRows)) {
                    void var10_13;
                    reader.nextColumn();
                    if (hasRowNames) {
                        reader.nextColumn();
                    }
                    reader.nextColumn();
                    cells = reader.getRowCellsAsString();
                    if (cells.size() != columnCount) {
                        throw new IOException(String.format("Row %d is not right size, expecting %d but was %d!", row, columnCount, cells.size()));
                    }
                    List<Integer> list3 = ConversionUtilities.getDataTypes(cells, (List<Integer>)var10_13);
                    ++row;
                    ++rowsRead;
                }
            }
            reader.close();
            if (colIds.size() != colNames.size()) {
                throw new IOException(String.format("Number of column IDs : %d  does not match number of column Name %d !", colIds.size(), colNames.size()));
            }
            if (var10_15.size() != colIds.size()) {
                throw new IOException(String.format("Number of headers : %d  does not match number of columns %d !", colIds.size(), var10_15.size()));
            }
            Iterator<String> iterator1 = colIds.iterator();
            Iterator iterator2 = colNames.iterator();
            Iterator iterator3 = var10_15.iterator();
            while (iterator1.hasNext()) {
                features.add(DatasetUtils.createDefaultColumnFeature(iterator1.next(), (String)iterator2.next(), (Integer)iterator3.next()));
            }
        }
        if (reader == null) return features;
        reader.close();
        return features;
    }
}

