% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cormap2.R
\name{clust_cormap}
\alias{clust_cormap}
\title{Cluster a correlation matrix and return the sorted matrix for plotting.}
\usage{
clust_cormap(
  cormat,
  na.frac = 0.1,
  distfn = function(cm) (1 - cm),
  method = "complete",
  cor.cluster = 1,
  cor.window = NULL,
  cor.thr = 0.8,
  cor.mar = 0.05,
  cut.thr = 0.9,
  cut.size = 5,
  list.output = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{cormat}{(\code{numeric} or \code{list}). The correlation matrix or a list containing matrices of correlation values
and P-Values as generated by \code{eset_cor}. If a list then the correlation matrix is expected to be in slot
'cor' and the matrix of P-Values in slot 'pvalues'.}

\item{na.frac}{(\code{numeric}). Fraction of missing values allowed per row of the input matrix. Defaults to \code{0.1} which
means LESS than 10per centof the values in one row are allowed to be NAs.}

\item{distfn}{(\code{function}). Function to calculate the dissimilarity matrix for clustering. Defaults to \code{function(cm) (1-cm)}.}

\item{method}{(\code{character}). The agglomeration method used for clustering. See help for \code{\link[stats]{hclust}}.
Defaults to "complete".}

\item{cor.cluster}{(\code{numeric}). The correlation cluster along the diagonal 'line' in the heatmap that should be
zoomed into. A sliding window of size \code{cor.window} will be moved along the diagonal of the correlation
matrix to find the cluster with the most corelation values meeting \code{core.thr}. Defaults to \code{1}.}

\item{cor.window}{(\code{numeric}). The size of the sliding window (see \code{cor.cluster}). Defaults to \code{NULL}.
Note that this works only for positive correlations.}

\item{cor.thr}{(\code{numeric}). Correlation threshold to filter the correlation matrix for plotting. Defaults to \code{NULL} meaning
no filtering. See also \option{cor.mar}. This value is sign-sensitive: a negative threshold will retain rows and columns of
the correlation matrix with correlation values between -1 and the threshold, a positive value will retain rows and columns
with values between the threshold and 1. Zero (0) is treated as positive.}

\item{cor.mar}{(\code{numeric}). Margin of the values per row of the correlation matrix the \option{cor.thr} filter needs to
meet. Defaults to \code{0.5} meaning at least 50 per cent of the values in a row need to meet the threshold in order to keep the row.}

\item{cut.thr}{(\code{numeric}). Threshold at which dendrogram branches are to be cut. Passed on to argument \code{cutHeight} in
\code{\link[WGCNA]{cutreeStatic}}. Defaults to \code{NULL} meaning no cutting.}

\item{cut.size}{(\code{numeric}). Minimum number of objects on a dendrogram branch considered a cluster. Passed on to argument
\code{minSize} in \code{\link[WGCNA]{cutreeStatic}}. Defaults to \code{5}.}

\item{list.output}{(\code{logical}). Should the output be a list of different object created in the call? Depends also on input
type. If \code{FALSE} only the (filtered) correlation matrix is returned.}

\item{verbose}{(\code{logical}). Should verbose output be written to the console? Defaults to \code{FALSE}.}
}
\value{
A correlation \code{matrix} or a \code{list} or the matrix and other values needed for plotting.
}
\description{
Helper function to cluster the correlation matrix and return the sorted matrix for plotting.
}
