% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nlp.R
\name{initCoreNLP}
\alias{initCoreNLP}
\title{Initialize the CoreNLP java object}
\usage{
initCoreNLP(libLoc, parameterFile, mem = "4g", annotators)
}
\arguments{
\item{libLoc}{a string giving the location of the CoreNLP java
files. This should point to a directory which
contains, for
example the file "stanford-corenlp-*.jar", where "*" is the
version number. If missing, the function will try to find the
library in the environment variable CORENLP_HOME, and otherwise
will fail.}

\item{parameterFile}{the path to a parameter file. See the CoreNLP documentation for
an extensive list of options. If missing, the package will simply
specify a list of standard annotators and otherwise only use default
values.}

\item{mem}{a string giving the amount of memory to be assigned to the rJava
engine. For example, "6g" assigned 6 gigabytes of memory. At least
2 gigabytes are recommended at a minimum for running the CoreNLP
package. On a 32bit machine, where this is not possible, setting
"1800m" may also work. This option will only have an effect the first
time \code{initCoreNLP} is called, and also will not have an effect if
the java engine is already started by a seperate process.}

\item{annotators}{optional character string. When parameterFile is missing, this
is taken to be the list of annotators that you want to run. Either
a length one character vector with annotator names seperated by
commas, or a character vector with one annotator per element.}
}
\description{
This must be run prior to calling any other CoreNLP
functions. It may be called multiple times in order
to specify a different parameter set, but note that
if you use a different configuration during the same
R session it must have a unique name.
}
\examples{
\dontrun{
initCoreNLP()
sIn <- "Mother died today. Or, maybe, yesterday; I can't be sure."
annoObj <- annotateString(sIn)
}
}

