% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linuxspaces.R
\name{linuxspaces}
\alias{linuxspaces}
\title{Handle spaces in Linux filenames}
\usage{
linuxspaces(txt)
}
\arguments{
\item{txt}{filename, which may contain ordinary spaces, e.g. "my file 1.txt"}
}
\value{
filename with modified spaces, e.g. "my\\ file\\ 1.txt"
}
\description{
Convert spaces in filenames (" ") to linux-type spaces "\ ", needed when calling system() on macOS.
}
\examples{
filename = '~/Desktop/my file 1.txt'
command = sprintf('ls -l \%s',linuxspaces(filename))
\dontrun{
system(command)
}

}
\author{
Danail Obreschkow
}
