% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svysst.R
\name{svysst}
\alias{svysst}
\alias{svysst.survey.design}
\alias{svysst.svyrep.design}
\alias{svysst.DBIsvydesign}
\title{Sen-Shorrocks-Thon poverty index (EXPERIMENTAL)}
\usage{
svysst(formula, design, ...)

\method{svysst}{survey.design}(
  formula,
  design,
  abs_thresh = NULL,
  na.rm = FALSE,
  components = FALSE,
  ...
)

\method{svysst}{svyrep.design}(
  formula,
  design,
  abs_thresh = NULL,
  na.rm = FALSE,
  components = FALSE,
  ...
)

\method{svysst}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{abs_thresh}{poverty threshold value}

\item{na.rm}{Should cases with missing values be dropped?}

\item{components}{Keep estimates of FGT(0), FGT(1), Gini index of poverty gap ratios.}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the Sen-Shorrocks-Thon poverty measure.
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\note{
This function is experimental and is subject to change in later versions.
}
\examples{
library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design

des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep( des_eusilc_rep )

# using linearized design
svysst( ~eqincome, des_eusilc, abs_thresh=10000 )

# using replicate design:
svysst( ~eqincome, des_eusilc_rep, abs_thresh = 10000 )


\dontrun{

# database-backed design
library(RSQLite)
library(DBI)
dbfile <- tempfile()
conn <- dbConnect( RSQLite::SQLite() , dbfile )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfile,
		dbtype="SQLite"
	)


dbd_eusilc <- convey_prep( dbd_eusilc )

# linearized SE:
svysst(~eqincome, dbd_eusilc, abs_thresh=10000)

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Anthony F. Shorrocks (1995). Revisiting the Sen Poverty Index.
\emph{Econometrica}, v. 63, n. 5, pp. 1225-230.
URL \url{http://www.jstor.org/stable/2171728}.

Dominique Thon (1979). On measuring poverty.
\emph{Review of Income and Wealth}, v. 25, n. 4, pp. 429-439.
URL \url{http://dx.doi.org/10.1111/j.1475-4991.1979.tb00117.x}.

Amartya K. Sen (1976). Poverty: An Ordinal Approach to Measurement.
\emph{Econometrica}, v. 44, n. 3, pp. 219-231.
URL \url{http://www.jstor.org/stable/1912718}.
}
\seealso{
\code{\link{svysen}}, \code{\link{svyfgt}}, \code{\link{svygini}}.
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
