% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problem.R
\name{problem_creating}
\alias{problem_creating}
\alias{minimize}
\alias{maximize}
\alias{satisfy}
\title{Create optimization problem}
\usage{
minimize(...)

maximize(...)

satisfy(...)
}
\arguments{
\item{...}{optimization targets and constraints.}
}
\description{
Create different kinds of optimization problems with
targets and constraints.
}
\examples{
\dontrun{
    convex_setup()
    x <- Variable(4)
    b <- J(c(1:4))
    p <- minimize(sum((x - b) ^ 2), x >= 0, x <= 3)
    p <- maximize(-sum((x - b) ^ 2), x >= 0, x <= 3)
    p <- satisfy(sum((x - b) ^ 2) <= 1, x >= 0, x <= 3)
}
}
