% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multianc.R
\name{multianc}
\alias{multianc}
\title{Reconstructs ancestral states for multiple characters}
\usage{
multianc(phy, phendata)
}
\arguments{
\item{phy}{The phylogeny of interest in phylo format}

\item{phendata}{Phenotypic data for all tips}
}
\value{
A matrix with the tips data in the first n rows and the ancestral data in the remaining n-1 rows.
}
\description{
Uses fastAnc to reconstruct ancestral states for multiple phenotypic characters
}
\details{
None
}
\examples{

phy<-rtree(10)

phendata<-fastBM(phy,nsim=2)

ancs<-multianc(phy,phendata)
}
\references{
Paradis, E., J. Claude, and K. Strimmer (2004) APE: Analyses of phylogenetics
and evolution in R langauge. Bioinformatics, 20, 289-290.

Revell, L. J. (2012) phytools: An R package for phylogenetic comparative 
biology (and other things). Methods Ecol. Evol. 3 217-223.
}
