% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretest.R
\name{pretest}
\alias{pretest}
\title{Prestest estimator}
\usage{
pretest(formula, alpha = 0.05)
}
\arguments{
\item{formula}{A formula describing the model to be fitted.}

\item{alpha}{The significant level. (default = \code{0.05})}
}
\value{
\code{pretest} returns an object of class "pretest", which is a list containing the following components:
   \item{\code{coefficients}}{The estimate of the coefficients in the outcome model.}
   \item{\code{vcov}}{The estimated covariance matrix of coefficients.}
   \item{\code{Hausman.stat}}{The Hausman test statistic used to test the validity of the extra IV generated by the control function.}
   \item{\code{p.value}}{The p-value of the Hausman test.}
   \item{\code{cf.check}}{The indicator that the extra IV generated by the control function is valid.}
}
\description{
This function implements the pretest estimator by comparing the control function and the TSLS estimators.
}
\details{
For example, the formula \code{Y ~ D + I(D^2)+X|Z+I(Z^2)+X} describes the models
\eqn{Y = \alpha_0 + D\beta_1 + D^2\beta_2 + X\phi + u}
and
\eqn{D = \gamma_0 + Z\gamma_1 + Z^2\gamma_2 + X\psi + v}.
Here, the outcome is \code{Y}, the endogenous variables is \code{D}, the baseline covariates are \code{X}, and the instrument variables are \code{Z}. The formula environment follows
that in the ivreg function in the AER package. The endogenous variable \code{D} must be in the first term of the formula for the outcome model.
}
\examples{
data("nonlineardata")
Y <- log(nonlineardata[,"insulin"])
D <- nonlineardata[,"bmi"]
Z <- as.matrix(nonlineardata[,c("Z.1","Z.2","Z.3","Z.4")])
X <- as.matrix(nonlineardata[,c("age","sex")])
pretest.model <- pretest(Y~D+I(D^2)+X|Z+I(Z^2)+X)
summary(pretest.model)

}
\references{
{
Guo, Z. and D. S. Small (2016), Control function instrumental variable estimation of nonlinear causal effect models, \emph{The Journal of Machine Learning Research} 17(1), 3448–3482. \cr
}
}
