% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cochran_Q_test_stratified_2x2.R
\name{Cochran_Q_test_stratified_2x2}
\alias{Cochran_Q_test_stratified_2x2}
\title{The Cochran Q test of homogeneity of effects over strata}
\usage{
Cochran_Q_test_stratified_2x2(n, link = "linear", estimatetype = "MH")
}
\arguments{
\item{n}{the observed table (a 2x2xk matrix, where k is the number of strata)}

\item{link}{the link function ('linear', 'log', or 'logit')}

\item{estimatetype}{Mantel-Haenszel or inverse variance estimate ('MH' or 'IV')}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Cochran Q test of homogeneity of effects over strata

Described in Chapter 10 "Stratified 2x2 Tables and Meta-Analysis"
}
\examples{
Cochran_Q_test_stratified_2x2(doll_hill_1950)
Cochran_Q_test_stratified_2x2(hine_1989)
}
