% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brant_test_2xc.R
\name{Brant_test_2xc}
\alias{Brant_test_2xc}
\title{The Brant test for the proportional odds assumption}
\usage{
Brant_test_2xc(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed table (a 2xc matrix)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A data frame containing the probability, the statistic and the degrees of freedom
}
\description{
The Brant test for the proportional odds assumption

Described in Chapter 6 "The Ordered 2xc Table"
}
\examples{
# The Adolescent Placement Study (Fontanella et al., 2008)
n <- rbind(c(8, 28, 72, 126), c(46, 73, 69, 86))
Brant_test_2xc(n)

# Postoperative nausea (Lydersen et al., 2012a)
n <- rbind(c(14, 10, 3, 2), c(11, 7, 8, 4))
Brant_test_2xc(n)

}
