% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/software-heritage.R
\name{history_swh}
\alias{history_swh}
\title{return the history of archive events of a given software repository}
\usage{
history_swh(origin_url, host = "https://archive.softwareheritage.org", ...)
}
\arguments{
\item{origin_url}{The url address to a GitHub, GitLab, or other recognized repository origin}

\item{host}{the domain name for the Software Heritage API}

\item{...}{additional arguments}
}
\description{
Note that unlike the generic \link{history} method, SWH history is repo-specific
rather than content-specific. An archive event adds all content from the repo
to the Software Heritage archival snapshot at once.  Any individual file can still
be referenced by its content identifier.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
history_swh("https://github.com/CSSEGISandData/COVID-19")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\link{history}, \link{store_swh}, \link{sources_swh}
}
