% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-SetR6.R
\name{OrderedSet}
\alias{OrderedSet}
\title{OrderedSet Class}
\description{
The \link{OrderedSet} is a \link{Set} where all elements are always
ordered.
}
\details{
The order of elements is determined sequentially as follows:
\itemize{
\item element's length
\item whether it is an atomic element
\item the element's class(es)
\item by numeric value (if applicable)
\item it's representation when printed
\item the name of the element in the \link{Set}
}
}
\examples{
s1 = OrderedSet$new(2, 1)
s1
}
\seealso{
\link{Container}, \link{Set}
}
\section{Super classes}{
\code{\link[container:Iterable]{container::Iterable}} -> \code{\link[container:Container]{container::Container}} -> \code{\link[container:Set]{container::Set}} -> \code{OrderedSet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OrderedSet-new}{\code{OrderedSet$new()}}
\item \href{#method-OrderedSet-add}{\code{OrderedSet$add()}}
\item \href{#method-OrderedSet-clone}{\code{OrderedSet$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="container" data-topic="Iterable" data-id="iter"><a href='../../container/html/Iterable.html#method-Iterable-iter'><code>container::Iterable$iter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at"><a href='../../container/html/Container.html#method-Container-at'><code>container::Container$at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at2"><a href='../../container/html/Container.html#method-Container-at2'><code>container::Container$at2()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="clear"><a href='../../container/html/Container.html#method-Container-clear'><code>container::Container$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="count"><a href='../../container/html/Container.html#method-Container-count'><code>container::Container$count()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete"><a href='../../container/html/Container.html#method-Container-delete'><code>container::Container$delete()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete_at"><a href='../../container/html/Container.html#method-Container-delete_at'><code>container::Container$delete_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="discard"><a href='../../container/html/Container.html#method-Container-discard'><code>container::Container$discard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="discard_at"><a href='../../container/html/Container.html#method-Container-discard_at'><code>container::Container$discard_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="empty"><a href='../../container/html/Container.html#method-Container-empty'><code>container::Container$empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="get_compare_fun"><a href='../../container/html/Container.html#method-Container-get_compare_fun'><code>container::Container$get_compare_fun()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has"><a href='../../container/html/Container.html#method-Container-has'><code>container::Container$has()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has_name"><a href='../../container/html/Container.html#method-Container-has_name'><code>container::Container$has_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="is_empty"><a href='../../container/html/Container.html#method-Container-is_empty'><code>container::Container$is_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="length"><a href='../../container/html/Container.html#method-Container-length'><code>container::Container$length()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="names"><a href='../../container/html/Container.html#method-Container-names'><code>container::Container$names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at"><a href='../../container/html/Container.html#method-Container-peek_at'><code>container::Container$peek_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at2"><a href='../../container/html/Container.html#method-Container-peek_at2'><code>container::Container$peek_at2()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="pop"><a href='../../container/html/Container.html#method-Container-pop'><code>container::Container$pop()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="print"><a href='../../container/html/Container.html#method-Container-print'><code>container::Container$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="remove"><a href='../../container/html/Container.html#method-Container-remove'><code>container::Container$remove()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="rename"><a href='../../container/html/Container.html#method-Container-rename'><code>container::Container$rename()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="replace"><a href='../../container/html/Container.html#method-Container-replace'><code>container::Container$replace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="replace_at"><a href='../../container/html/Container.html#method-Container-replace_at'><code>container::Container$replace_at()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="size"><a href='../../container/html/Container.html#method-Container-size'><code>container::Container$size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="type"><a href='../../container/html/Container.html#method-Container-type'><code>container::Container$type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Container" data-id="update"><a href='../../container/html/Container.html#method-Container-update'><code>container::Container$update()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Set" data-id="diff"><a href='../../container/html/Set.html#method-Set-diff'><code>container::Set$diff()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Set" data-id="intersect"><a href='../../container/html/Set.html#method-Set-intersect'><code>container::Set$intersect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Set" data-id="is_equal"><a href='../../container/html/Set.html#method-Set-is_equal'><code>container::Set$is_equal()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Set" data-id="is_proper_subset"><a href='../../container/html/Set.html#method-Set-is_proper_subset'><code>container::Set$is_proper_subset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Set" data-id="is_subset"><a href='../../container/html/Set.html#method-Set-is_subset'><code>container::Set$is_subset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Set" data-id="union"><a href='../../container/html/Set.html#method-Set-union'><code>container::Set$union()</code></a></span></li>
<li><span class="pkg-link" data-pkg="container" data-topic="Set" data-id="values"><a href='../../container/html/Set.html#method-Set-values'><code>container::Set$values()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OrderedSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-OrderedSet-new}{}}}
\subsection{Method \code{new()}}{
\code{OrderedSet} constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OrderedSet$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{initial elements put into the \code{OrderedSet}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
returns the \code{OrderedSet} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OrderedSet-add"></a>}}
\if{latex}{\out{\hypertarget{method-OrderedSet-add}{}}}
\subsection{Method \code{add()}}{
Add element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OrderedSet$add(value, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value of \code{ANY} type to be added to the \code{OrderedSet}.}

\item{\code{name}}{\code{character} optional name attribute of the value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{OrderedSet} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OrderedSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OrderedSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OrderedSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
