% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-SetR6.R
\name{Set}
\alias{Set}
\title{Set Class}
\description{
The \link{Set} is considered and implemented as a specialized
\link{Container}, that is, elements are always unique in the \link{Container} and
it provides typical set operations such as \code{union} and \code{intersect}.
For the standard S3 interface, see \code{\link[=setnew]{setnew()}}.
}
\examples{
s1 = Set$new(1, 2)
s1
s1$add(1)
s1$add(3)
s2 = Set$new(3, 4, 5)
s1$union(s2)
s1

s1 = Set$new(1, 2, 3)
s1$intersect(s2)
s1

s1$diff(s2)
s1$diff(s1)
s1
}
\seealso{
\link{Container}, \code{\link[=set]{set()}}
}
\section{Super classes}{
\code{\link[container:Iterable]{container::Iterable}} -> \code{\link[container:Container]{container::Container}} -> \code{Set}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Set$new()}}
\item \href{#method-add}{\code{Set$add()}}
\item \href{#method-diff}{\code{Set$diff()}}
\item \href{#method-intersect}{\code{Set$intersect()}}
\item \href{#method-union}{\code{Set$union()}}
\item \href{#method-is_equal}{\code{Set$is_equal()}}
\item \href{#method-is_subset}{\code{Set$is_subset()}}
\item \href{#method-is_proper_subset}{\code{Set$is_proper_subset()}}
\item \href{#method-values}{\code{Set$values()}}
\item \href{#method-clone}{\code{Set$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Iterable" data-id="iter">}\href{../../container/html/Iterable.html#method-iter}{\code{container::Iterable$iter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at">}\href{../../container/html/Container.html#method-at}{\code{container::Container$at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at2">}\href{../../container/html/Container.html#method-at2}{\code{container::Container$at2()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="clear">}\href{../../container/html/Container.html#method-clear}{\code{container::Container$clear()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="count">}\href{../../container/html/Container.html#method-count}{\code{container::Container$count()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete">}\href{../../container/html/Container.html#method-delete}{\code{container::Container$delete()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete_at">}\href{../../container/html/Container.html#method-delete_at}{\code{container::Container$delete_at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="discard">}\href{../../container/html/Container.html#method-discard}{\code{container::Container$discard()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="discard_at">}\href{../../container/html/Container.html#method-discard_at}{\code{container::Container$discard_at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="empty">}\href{../../container/html/Container.html#method-empty}{\code{container::Container$empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="get_compare_fun">}\href{../../container/html/Container.html#method-get_compare_fun}{\code{container::Container$get_compare_fun()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has">}\href{../../container/html/Container.html#method-has}{\code{container::Container$has()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has_name">}\href{../../container/html/Container.html#method-has_name}{\code{container::Container$has_name()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="is_empty">}\href{../../container/html/Container.html#method-is_empty}{\code{container::Container$is_empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="length">}\href{../../container/html/Container.html#method-length}{\code{container::Container$length()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="names">}\href{../../container/html/Container.html#method-names}{\code{container::Container$names()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at">}\href{../../container/html/Container.html#method-peek_at}{\code{container::Container$peek_at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at2">}\href{../../container/html/Container.html#method-peek_at2}{\code{container::Container$peek_at2()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="pop">}\href{../../container/html/Container.html#method-pop}{\code{container::Container$pop()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="print">}\href{../../container/html/Container.html#method-print}{\code{container::Container$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="remove">}\href{../../container/html/Container.html#method-remove}{\code{container::Container$remove()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="rename">}\href{../../container/html/Container.html#method-rename}{\code{container::Container$rename()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="replace">}\href{../../container/html/Container.html#method-replace}{\code{container::Container$replace()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="replace_at">}\href{../../container/html/Container.html#method-replace_at}{\code{container::Container$replace_at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="size">}\href{../../container/html/Container.html#method-size}{\code{container::Container$size()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="type">}\href{../../container/html/Container.html#method-type}{\code{container::Container$type()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="update">}\href{../../container/html/Container.html#method-update}{\code{container::Container$update()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\code{Set} constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{initial elements put into the \code{Set}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
returns the \code{Set} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add"></a>}}
\if{latex}{\out{\hypertarget{method-add}{}}}
\subsection{Method \code{add()}}{
Add element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$add(value, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value of \code{ANY} type to be added to the \code{Set}.}

\item{\code{name}}{\code{character} optional name attribute of the value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Set} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-diff"></a>}}
\if{latex}{\out{\hypertarget{method-diff}{}}}
\subsection{Method \code{diff()}}{
\code{Set} difference
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$diff(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to 'subtract'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Set} object updated as a result of the set difference
between this and s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intersect"></a>}}
\if{latex}{\out{\hypertarget{method-intersect}{}}}
\subsection{Method \code{intersect()}}{
\code{Set} intersection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$intersect(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to 'intersect'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Set} object as a result of the intersection of this and s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-union"></a>}}
\if{latex}{\out{\hypertarget{method-union}{}}}
\subsection{Method \code{union()}}{
\code{Set} union
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$union(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to be 'unified'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Set} object as a result of the union of this and s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_equal"></a>}}
\if{latex}{\out{\hypertarget{method-is_equal}{}}}
\subsection{Method \code{is_equal()}}{
\code{Set} equality
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$is_equal(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to compare against}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if this is equal to \code{s}, otherwise \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_subset"></a>}}
\if{latex}{\out{\hypertarget{method-is_subset}{}}}
\subsection{Method \code{is_subset()}}{
\code{Set} proper subset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$is_subset(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to compare against}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if this is subset of \code{s}, otherwise \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_proper_subset"></a>}}
\if{latex}{\out{\hypertarget{method-is_proper_subset}{}}}
\subsection{Method \code{is_proper_subset()}}{
\code{Set} subset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$is_proper_subset(s)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{\code{Set} object to compare against}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if this is proper subset of \code{s}, otherwise \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-values"></a>}}
\if{latex}{\out{\hypertarget{method-values}{}}}
\subsection{Method \code{values()}}{
Get \code{Set} values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$values()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
elements of the set as a base list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Set$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
