% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/at2.R
\name{at2}
\alias{at2}
\alias{at2.Container}
\alias{at2.dict.table}
\title{Extract Single Elements Safely}
\usage{
at2(x, ...)

\method{at2}{Container}(x, index, ...)

\method{at2}{dict.table}(x, index, ...)
}
\arguments{
\item{x}{an \code{R} object of the respective class.}

\item{...}{other arguments passed to or from methods.}

\item{index}{\code{character} name or \code{numeric} position of the sought value.}
}
\value{
For \code{Container}, returns the value at the given index.

For \code{dict.table}, returns the column at the given \code{index} or signals
an error if not found.
}
\description{
Extracts the value of a Container at the given index. If the index is
invalid, an error is signaled. If given as a string, the element matching the
name is returned. If there are two or more identical names, the value of the
first match (i.e. \emph{leftmost} element) is returned.
Extract value at index. If index is invalid or not found, an error is
signaled. If given as a string, the element matching the name is returned.
If there are two or more identical names, the value of the first match (i.e.
\emph{leftmost} element) is returned.
}
\examples{

# Container
co = container(a = 1, 2, b = 3, 4)
at2(co, 1)
at2(co, "a")
at2(co, 2)
\dontrun{
at2(co, "x")     # index 'x' not found
at2(co, 5)       # index 5 exceeds length of Container
}
# Dict
d = dict(a = 1, b = 3)
at2(d, 1)
at2(d, "a")
at2(d, 2)
\dontrun{
at2(d, "x")     # index 'x' not found
at2(d, 5)       # index 5 exceeds length of Dict
}

# dict.table
dit = dict.table(a = 1:3, b = 4:6)
at2(dit, 1)
at2(dit, "a")
at2(dit, 2)
\dontrun{
at2(dit, "x")     # index 'x' not found
at2(dit, 5)       # index 5 exceeds length of dict.table
}
}
\seealso{
\code{\link[=peek_at2]{peek_at2()}} for less strict extraction
}
