% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-S3.R
\name{setS3}
\alias{setS3}
\alias{set}
\alias{as.set}
\alias{is.set}
\title{Set constructors}
\usage{
set(x = list())

as.set(x)

is.set(x)
}
\arguments{
\item{x}{(vector or list) initial elements of the set}
}
\description{
The \code{set} is considered and implemented as a specialized
 \code{\link[container]{container}} in which elements are always unique. It
 provides typical set operations such as \code{union (+)} and
 \code{intersect (/)}.
}
\section{S3 methods for class \code{Set}}{

\describe{
 \item{\code{add(x, elem)}}{If not already in set \code{x}, add \code{elem}.}
}
}

\examples{
s1 <- set(list(1, 2, "A", "B"))
s2 <- set(values(s1))
s1 == s2     # TRUE
s1$add(1)    # 1 was already in set, therefore ...
s1 == s2     # ... still TRUE
s1$add(3)
s1 == s2     # FALSE
s1 > s2      # TRUE
s1 - s2      # the added element
unlist(values(s1 / s2))

\dontrun{
s1$remove(4)              # Error: 3 not in Set
}
}
\seealso{
\code{\link[container]{container}}, \code{\link[container]{Set}},
 \code{\link[container]{+.Set}},
 \code{\link[container]{/.Set}},
 \code{\link[container]{-.Set}},
 \code{\link[container]{<.Set}},
 \code{\link[container]{>.Set}}
}
\author{
Roman Pahl
}
