% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/container.R
\docType{class}
\name{Container}
\alias{Container}
\title{A sequence container}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Container
}
\description{
This class implements a container data structure with typical
member functions to insert, delete and access objects from the container. It
also serves as the base class for \code{\link[container]{Deque}},
\code{\link[container]{Set}}, and \code{\link[container]{Dict}}.
}
\details{
The underlying data structure is based on R vectors (or lists), with the mode
being set to the mode (or type) of the value passed to the initialize
function, which by default is an empty list, in which case the
\code{Container} object can store objects of mixed and arbitrary types.
If the container will only contain objects of one particular type, for
example, double values, it will be both more efficient and type safe to
initialize the container using this particular type (see Examples section).
}
\section{R6 constructor}{

\code{Container$new(x=list())}
}

\section{Container methods}{

\describe{
 \item{\code{add(elem)}}{Add \code{elem} to \code{Container}.}
 \item{\code{apply(f)}}{Apply function f to all elements and return results
 in a list)}
 \item{\code{clear()}}{Remove all elements from the \code{Container}.}
 \item{\code{discard(elem, right=FALSE)}}{Search for first \code{elem} in
     \code{Container} and, if found, remove it. If \code{right} is
     \code{TRUE}, search from right to left.}
 \item{\code{empty()}}{Return \code{TRUE} if the \code{Container} is empty,
     else \code{FALSE}.}
 \item{\code{has(elem)}}{Return \code{TRUE} if \code{Container} contains
     \code{elem} else \code{FALSE}.}
 \item{\code{print(list.len)}}{Print object representation similar to
     \code{\link[utils]{str}}}
 \item{\code{remove(elem, right=FALSE)}}{Same as \code{discard}, but throw an
     error if not found.}
 \item{\code{size()}}{Return size of the \code{Container}.}
 \item{\code{type()}}{Return type (or mode) of internal vector containing
 the elements.}
 \item{\code{values()}}{Return a copy of all elements in the same format
 as they are stored in the object.}
}
}

\examples{
c0 <- Container$new()
c0$size()                            # 0
c0$add(1)
c0$add(2)$add("A")                   # chaining example
c0$has(2)                            # TRUE
c0$discard(2)$has(2)                 # FALSE

\dontrun{
c0$remove(2)                         # Error : 2 not in Container
}
c0$discard(2)$has(2)                 # still FALSE, but no error

# Container types
Container$new(list("A", 1))$type()   # "list"
Container$new(numeric(0))$type()     # "double"
Container$new(0+0i)$type()           # "complex"
Container$new(letters[1:3])$type()   # "character"
Container$new(letters[1:3])$values() # "a" "b" "c"
Container$new(1L)$type()             # "integer"
Container$new(1L)$add(2.3)$values()  # since integer type, equals c(1, 2)
}
\seealso{
\code{\link[container]{Iterable}}, \code{\link[container]{Deque}},
\code{\link[container]{Set}}, and \code{\link[container]{Dict}}
}
\author{
Roman Pahl
}
\keyword{datasets}
