% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dateFake.R
\name{dateFake}
\alias{dateFake}
\title{Create Fake Date Information}
\usage{
dateFake(timestamp, dateFormat = "mdy", startYear = 2000)
}
\arguments{
\item{timestamp}{Vector of time information with format 
"hour:minute:second."}

\item{dateFormat}{Character string. Defines how date information will be 
presented in output. Takes values "mdy" (i.e., month/day/year), "ymd" 
(i.e., year/month/day), "dmy" (i.e., day/month/year), or "ydm" 
(i.e., year/day/month). Defaults to "mdy."}

\item{startYear}{Numerical. Denotes what year fake date information will 
begin if dateFake == TRUE. Defaults to 2000.}
}
\value{
Output is a vector of date values (e.g., "01-1-2000") with length 
   length(\code{timestamp}).
}
\description{
This function assigns fake date information, beginning 01/01/startYear, to 
   each empirical timestamp. Users can control what format the output vector
   is in by changing the dateFormat argument 
   (format: "mdy" =  month-day-year, "ymd" =  year-month-day, 
   "dmy" =  day-month-year, or "ydm" =  year-day-month).
   
This is a sub-function that can be found within datetime.append.
}
\details{
Note that the timestamp argument should be a vector of all relevant 
   timepoints. Additionally, timepoints should be in hms ("hour, minute, 
   second") format.
}
\examples{

data("calves")
dateFake(calves$time, dateFormat = "mdy", startYear = 2000) 
}
\keyword{data-processing}
\keyword{sub-function}
