% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.calc.R
\name{dt.calc}
\alias{dt.calc}
\title{Calculate Time Difference Between Relocations}
\usage{
dt.calc(x = NULL, id = NULL, dateTime1 = NULL, dateTime2 = NULL,
  timeUnits = "secs", parallel = FALSE,
  nCores = parallel::detectCores(), timeStepRelation = 1)
}
\arguments{
\item{x}{data frame containing time data. If NULL at least dateTime must be 
defined. Defaults to NULL.}

\item{id}{Vector of length nrow(data.frame(x)) or singular character data, 
detailing the relevant colname in x, that denotes what unique ids for 
tracked individuals will be used. If argument == NULL, the function 
assumes a column with the colname "id" exists in x. Defaults to NULL.}

\item{dateTime1}{Vector of length nrow(data.frame(x)) or singular 
character data, detailing the relevant colname in x, that denotes what 
dateTime information will be used. If argument == NULL, the function 
assumes a column with the colname "dateTime" exists in x. Defaults to 
NULL.}

\item{dateTime2}{Vector of length nrow(data.frame(x)) or singular 
character data, detailing the relevant colname in x, that denotes what 
dateTime information will be used. If argument == NULL, the function 
will calculate differences between sequential timepoints in dateTime1. If
!= NULL, the function will calculate differences between dateTime1 and 
dateTime2 values. Defaults to NULL.}

\item{timeUnits}{Chracter string describing the time unit of calculated 
differences. It takes the values "secs," "mins," "hours," "days," or 
"weeks." Defaults to "secs."}

\item{parallel}{Logical. If TRUE, sub-functions within the dt.calc wrapper 
will be parallelized. Note that this can significantly speed up 
processing of relatively small data sets, but may cause R to crash due to
lack of available memory when attempting to process large datasets. 
Defaults to FALSE.}

\item{nCores}{Integer. Describes the number of cores to be dedicated to 
parallel processes. Defaults to the maximum number of cores available
(i.e., parallel::detectCores()).}

\item{timeStepRelation}{Numerical. Takes the value "1" or "2." If 
argument == "1," dt values in output represent the difference between 
time t and time t-1. If argument == "2," dt values in output represent 
the difference between time t and time t+1. Defaults to 1.}
}
\value{
Output is a data frame with the following columns

   \item{id}{The unique ID of a tracked individual.}
   \item{dt}{Time difference between relocation events.}
   \item{units}{Temporal unit defined by \code{timeUnits} argument.}
}
\description{
This function calculates the time difference between relocation events, 
   accounting for individuals' ids. This function has the capability to 
   calculate the differences between sequential timepoints related to two 
   different features (e.g., contactStartTime and contactEndTime) if both 
   dateTime1 and dateTime2 are defined, or just sequential timepoints from a
   single vector (e.g., contactStartTime) if only dateTime1 is defined.
   
This is a sub-function contained within contactDur variants and contactTest 
   functions.
}
\examples{
data(calves) #load calves data set
calves.datetime<-datetime.append(calves)
dt<-dt.calc(x = calves.datetime, id = calves.datetime$calftag, 
   dateTime1 = calves.datetime$dateTime, dateTime2 = NULL, 
   timeUnits = "secs", parallel = FALSE, timeStepRelation = 1)
   
head(dt)
}
\keyword{contact}
\keyword{data-processing}
\keyword{sub-function}
