% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-array.R
\name{opts_array}
\alias{opts_array}
\title{Constructive options for arrays}
\usage{
opts_array(constructor = c("array", "next"), ...)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the environment, see Details section.}

\item{...}{Should not be used. Forces passing arguments by name.}
}
\value{
An object of class <constructive_options/constructive_options_array>
}
\description{
These options will be used on arrays. Note that arrays can be built on top of
vectors, lists or expressions. Canonical arrays have an implicit class "array"
shown by \code{class()} but "array" is not part of the class attribute.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"array"} (default): Use the \code{array()} function
\item \code{"next"} : Use the constructor for the next supported class. Call \code{.class2()}
on the object to see in which order the methods will be tried.
}
}
