% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/de_functions.R
\name{getBetweenCellTypeCorrectedDE}
\alias{getBetweenCellTypeCorrectedDE}
\title{Compare two cell types across the entire panel}
\usage{
getBetweenCellTypeCorrectedDE(
  con.obj,
  sample.groups = NULL,
  groups = NULL,
  cooks.cutoff = FALSE,
  refgroup = NULL,
  altgroup = NULL,
  min.cell.count = 10,
  independent.filtering = FALSE,
  cluster.sep.chr = "<!!>",
  return.details = TRUE,
  only.paired = TRUE,
  correction = NULL,
  ref.level = NULL
)
}
\arguments{
\item{con.obj}{conos object}

\item{sample.groups}{a named list of two character vectors specifying the app groups to compare}

\item{groups}{factor describing cell grouping}

\item{cooks.cutoff}{cooksCutoff parameter for DESeq2}

\item{refgroup}{cell type to compare to be used as reference}

\item{altgroup}{cell type to compare to}

\item{min.cell.count}{minimum number of cells per celltype/sample combination to keep}

\item{independent.filtering}{independentFiltering parameter for DESeq2}

\item{cluster.sep.chr}{character string of length 1 specifying a delimiter to separate cluster and app names}

\item{return.details}{logical, return detailed results}

\item{only.paired}{only keep samples that that both cell types above the min.cell.count threshold}

\item{correction}{fold change corrections per genes}

\item{ref.level}{reference level on the basis of which the correction was calculated}
}
\value{
Returns either a DESeq2::results() object, or if return.details=TRUE,
   returns a list of the DESeq2::results(), the samples from the panel to use in this comparison, refgroups, altgroup, and samplegroups
}
\description{
Compare two cell types across the entire panel
}
