% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conos.R
\name{getNeighborMatrix}
\alias{getNeighborMatrix}
\title{Establish rough neighbor matching between samples given their projections in a common space}
\usage{
getNeighborMatrix(
  p1,
  p2,
  k,
  k1 = k,
  matching = "mNN",
  metric = "angular",
  l2.sigma = 1e+05,
  cor.base = 1,
  min.similarity = 1e-05
)
}
\arguments{
\item{p1}{projection of sample 1}

\item{p2}{projection of sample 2}

\item{k}{neighborhood radius}

\item{k1}{neighborhood radius}

\item{matching}{string mNN (default) or NN (default='mNN')}

\item{metric}{string Distance type (default: "angular", can also be 'L2')}

\item{l2.sigma}{numeric L2 distances get transformed as exp(-d/sigma) using this value (default=1e5)}

\item{cor.base}{numeric (default=1)}

\item{min.similarity}{minimal similarity between two cells, required to have an edge}
}
\value{
matrix with the similarity (!) values corresponding to weight (1-d for angular, and exp(-d/l2.sigma) for L2)
}
\description{
Establish rough neighbor matching between samples given their projections in a common space
}
\keyword{internal}
