% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_audit_logs}
\alias{get_audit_logs}
\title{Get Audit Logs from Posit Connect Server}
\usage{
get_audit_logs(src, limit = 500, previous = NULL, nxt = NULL, asc_order = TRUE)
}
\arguments{
\item{src}{The source object}

\item{limit}{The number of records to return.}

\item{previous}{Retrieve the previous page of Shiny application usage
logs relative to the provided value. This value corresponds to an internal
reference within the server and should be sourced from the appropriate
attribute within the paging object of a previous response.}

\item{nxt}{Retrieve the next page of Shiny application usage logs
relative to the provided value. This value corresponds to an internal
reference within the server and should be sourced from the appropriate
attribute within the paging object of a previous response.}

\item{asc_order}{Defaults to TRUE; Determines if the response records
should be listed in ascending or descending order within the response.
Ordering is by the started timestamp field.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{id}: ID of the audit action
\item \code{time}: Timestamp in RFC3339 format when action was taken
\item \code{user_id}: User ID of the actor who made the audit action
\item \code{user_description}: Description of the actor
\item \code{action}: Audit action taken
\item \code{event_description}: Description of action
}
}
\description{
Get Audit Logs from Posit Connect Server
}
\details{
Please see https://docs.posit.co/connect/api/#get-/v1/audit_logs for more
information.
}
\examples{
\dontrun{
library(connectapi)
client <- connect()

# get the last 20 audit logs
get_audit_logs(client, limit = 20, asc_order = FALSE)
}

}
