% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldComradesMethodsAndHelpers.R
\docType{methods}
\name{plotEnsemblePCA}
\alias{plotEnsemblePCA}
\alias{plotEnsemblePCA,comradesDataSet-method}
\title{plotEnsemblePCA}
\usage{
plotEnsemblePCA(foldedCds, labels = TRUE, split = TRUE)
}
\arguments{
\item{foldedCds}{\code{comradesDataSet} after running foldComrades}

\item{labels}{plot with labels or not (TRUE/FALSE)}

\item{split}{split the plot using facets based on the samples  (TRUE/FALSE)}
}
\value{
a PCA plot of the ensembl
}
\description{
This method plots a PCA of the ensembl
}
\examples{
\dontrun{
cds = makeExampleComradesDataSet()
clusteredCds = clusterComrades(cds = cds,
                               cores = 3,
                               stepCount = 2,
                               clusterCutoff = 1)


trimmedClusters = trimClusters(clusteredCds = clusteredCds,trimFactor = 1, clusterCutoff = 1)



fasta = paste(c(rep('A',25),
                rep('T',25),
                rep('A',10),
                rep('T',23)),collapse = "")

header = '>transcript1'


fastaFile = tempfile()
writeLines(paste(header,fasta,sep = "\n"),con = fastaFile)


rnaRefs = list()
rnaRefs[[rnas(cds)]] = read.fasta(fastaFile)
rnaRefs



foldedCds = foldComrades(trimmedClusters,
                         rnaRefs = rnaRefs,
                         start = 1,
                         end = 83,
                         shape = 0,
                         ensembl = 5,
                         constraintNumber  = 1,
                         evCutoff = 1)


plotEnsemblePCA(foldedCds)
}
}
