% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldComradesMethodsAndHelpers.R
\docType{methods}
\name{compareKnownStructures}
\alias{compareKnownStructures}
\alias{compareKnownStructures,comradesDataSet-method}
\title{compareKnownStructures}
\usage{
compareKnownStructures(foldedCds, file)
}
\arguments{
\item{foldedCds}{\code{comradesDataSet} after running foldComrades}

\item{file}{a two column file with column header i and j with numeric values showing
nucleoide i binds to nucleotide j}
}
\value{
Returns a dataframe

a tables showing the number of predicted interactions and their agreement
}
\description{
This method compares the predicted structures to a set of known interactions
}
\examples{
\dontrun{
cds = makeExampleComradesDataSet()
clusteredCds = clusterComrades(cds = cds,
                               cores = 3,
                               stepCount = 2,
                               clusterCutoff = 1)


trimmedClusters = trimClusters(clusteredCds = clusteredCds,trimFactor = 1, clusterCutoff = 1)



fasta = paste(c(rep('A',25),
                rep('T',25),
                rep('A',10),
                rep('T',23)),collapse = "")

header = '>transcript1'


fastaFile = tempfile()
writeLines(paste(header,fasta,sep = "\n"),con = fastaFile)


rnaRefs = list()
rnaRefs[[rnas(cds)]] = read.fasta(fastaFile)
rnaRefs



foldedCds = foldComrades(trimmedClusters,
                         rnaRefs = rnaRefs,
                         start = 1,
                         end = 83,
                         shape = 0,
                         ensembl = 5,
                         constraintNumber  = 1,
                         evCutoff = 1)


# make an example table of "know" interactions
file = data.frame(V1 = c(6), 
                  V2 = c(80))
compareKnownStructures(foldedCds,file)
}
}
