% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{get_experiment}
\alias{get_experiment}
\title{get_experiment}
\usage{
get_experiment(
  experiment_key,
  api_key = NULL,
  keep_active = FALSE,
  log_output = FALSE,
  log_error = FALSE,
  log_code = FALSE,
  log_system_details = FALSE,
  log_git_info = FALSE
)
}
\arguments{
\item{experiment_key}{Experiment key.}

\item{api_key}{Comet API key (can also be specified using the \code{COMET_API_KEY}
parameter as an environment variable or in a comet config file).}

\item{keep_active}{if \code{TRUE} keeps a communication channel open with comet.ml}

\item{log_output}{If \code{TRUE}, all standard output will automatically be sent to
the Comet servers to display as message logs for the experiment. The output will still
be shown in the console as well.}

\item{log_error}{If \code{TRUE}, all output from 'stderr' (which includes errors,
warnings, and messages) will be redirected to the Comet servers to display as message
logs for the experiment. Note that unlike \code{auto_log_output}, if this option is on then
these messages will not be shown in the console and instead they will only be logged
to the Comet experiment. This option is set to \code{FALSE} by default because of this
behaviour.}

\item{log_code}{If \code{TRUE}, log the source code of the R script that was called
to Comet as the associated code of this experiment. This only works if the you run
a script using the \code{Rscript} tool and will not work in interactive sessions.}

\item{log_system_details}{If \code{TRUE}, automatically log the system details to
Comet when the experiment is created.}

\item{log_git_info}{If \code{TRUE}, log information about the active git repository.
Requires the \code{git2r} package to be installed.}
}
\value{
An \code{\link{Experiment}} object.
}
\description{
Get a previously created experiment

Get a previously created experiment on Comet's servers. The return value is an \code{\link{Experiment}}
object that can be used to modify or get information about the experiment.
}
\examples{
\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY, COMET_WORKSPACE, COMET_PROJECT_NAME variables defined
exp <- get_experiment("SOME-EXPERIMENT-KEY")
exp$get_key()
exp$get_metadata()
exp$add_tags(c("test", "tag2"))
exp$get_tags()
exp$log_metric("metric1", 5)
exp$get_metric("metric1")
exp$get_metrics_summary()
exp$stop()
}

}
