% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clcolors.r
\name{clcolors}
\alias{clcolors}
\alias{clcolor}
\alias{print.clcolor}
\alias{print.clcolors}
\title{Retrieve color or colors}
\usage{
clcolors(set = NULL, ..., fmt = "xml")

clcolor(hex, fmt = "xml")
}
\arguments{
\item{set}{Optionally, a subset of COLOURlovers colors. Allowed values are
\dQuote{new}, \dQuote{top}, and \dQuote{random}.}

\item{...}{A named list of parameters passed to the API request. Allowed
parameters are \code{lover}, \code{hueRange}, \code{briRange},
\code{keywords}, \code{keywordExact}, \code{orderCol}, \code{sortBy},
\code{numResults}, and \code{resultOffset}. Specifying \code{orderCol}
overrules any argument to \code{set}. See details.}

\item{fmt}{A format for the API response, one of \dQuote{xml} (the default)
or \dQuote{json}. This has essentially no effect on function behavior.
@return A list of class \dQuote{clcolor}. This should be the same regardless
of the value of \code{fmt}.}

\item{hex}{The six-character hexidemical representation of a single color.}
}
\description{
Retrieve a color or set of colors from the COLOURlovers API.
}
\details{
Retrieve details about a color our set of colors.

Specifying named arguments to \code{...} allows the user to request a
specific response, as follows:

\itemize{
  \item \code{lover}: A character string containing a COLOURlovers username.
  \item \code{hueRange}: A two-element numeric vector containing the upper and lower
        bounds of a hue range. Allowed values are between 0 and 359, exclusive.
  \item \code{briRange}: A two-element numeric vector containing the upper and lower
        bounds of a brightness range. Allowed values are between 0 and 99,
        exclusive.
  \item \code{keywords}: A character string containing one or more keywords to
        search by.
  \item \code{keywordExact}: A boolean indicating search on keywords should be
        exact (\code{TRUE}) or not (\code{FALSE}, the API default).
  \item \code{orderCol}: A character string containing a sort criterion. One of
        \dQuote{dateCreated}, \dQuote{score}, \dQuote{name}, \dQuote{numVotes},
        \dQuote{numViews}.
  \item \code{sortBy}: A character string containing either \dQuote{ASC} (for
        ascending by the \code{orderCol} criterion, the default) or \dQuote{DSC}
        (for descending).
  \item \code{numResults}: A numeric value indicating the number of results to
        return, with a maximum of 100. Default is 20.
  \item \code{resultOffset}: A numeric value indicating the page of results to
        return, with page size specified in the \code{numResults} argument.
}
}
\examples{
\dontrun{
# Get a random color
clcolors('random')

# Get a single color
clcolor('6B4106')

# Plot a single color
clcolor(rgb(0,0,1), fmt = 'json')
}
}
\references{
\url{http://www.colourlovers.com/api/#colors}
}
\author{
Thomas J. Leeper
}
