% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metrics_distill}
\alias{metrics_distill}
\title{Distill a raster stack into a set of distribution metrics}
\usage{
metrics_distill(x)
}
\arguments{
\item{x}{RasterStack of distributions. Layers typically contain information
about the distribution of a single individual or species at multiple points
in time. Alternatively, layers may contain information about the
distributions of multiple individuals or species within a single time
period. Other conceptualizations are possible.}
}
\value{
A RasterStack with four layers:
\itemize{
\item \code{intensity}: the maximum intensity value across all layers.
\item \code{layer_id}: an integer identifying layer containing the maximum intensity
value.
\item \code{specificity}: the degree to which intensity values are unevenly
distributed across layers (see Details).
\item \code{n_layers}: the number of layers with non-NA values (see Details).
}

The maximum cell value in the stack is stored as the \code{"maximum"} attribute.
The link between the \code{layer_id} and the layer names from the underlying
raster is stored as a data frame in the \code{layer_names} attribute.
}
\description{
This function is used to summarize several distributional
features of interest across a series of distributions. Distributional
information in the original raster stack is "distilled" for subsequent
visualization.
}
\details{
Specificity values range from 0 to 100. Values of 0 indicate
intensity values are identical in all layers. Values of 100 indicate
intensity values are restricted to a single layer. Interpretation of
specificity values depends on the layers provided. If layers describe the
distribution of a species at different times of the year, specificity can
be interpreted as a measure of seasonality (i.e., 0 = stable year-round
occurrence in a cell, 100 = highly seasonal occurrence). If layers describe
space use by multiple individuals, specificity can be interpreted as a
measure of exclusivity (i.e., 0 = equal use of a cell by all individuals,
100 = exclusive use by one individual).

The number of layers with non-NA values is recorded to aid interpretation
of distributions. Ideally, n_layers values are identical in every cell,
indicating that users have knowledge of distributions over the same area in
every layer of their raster stack. When n_layers values are unequal, it
indicates that users have unequal knowledge of distributions in their
raster stack. Distributions are more likely to be misrepresented and
misinterpreted if cells do not contain intensity values in every layer.
}
\examples{
# load elephant data
data("elephant_ud")

# distill
r <- metrics_distill(elephant_ud)
print(r)

# maximum value across all layers stored as an attribute
attr(r, "maximum")
# link between layer id and name stored as an attribute
attr(r, "layer_names")
}
\seealso{
Other metrics: 
\code{\link{metrics_pull}()}
}
\concept{metrics}
