% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_palettehex.R
\name{scale-palettehex}
\alias{scale-palettehex}
\alias{scale_colour_palettehex_d}
\alias{scale_color_palettehex_d}
\alias{scale_fill_palettehex_d}
\alias{scale_colour_palettehex_c}
\alias{scale_color_palettehex_c}
\alias{scale_fill_palettehex_c}
\title{Colour scales for ggplot2}
\usage{
scale_colour_palettehex_d(x, which = 1, reverse = FALSE, ...)

scale_color_palettehex_d(x, which = 1, reverse = FALSE, ...)

scale_fill_palettehex_d(x, which = 1, reverse = FALSE, ...)

scale_colour_palettehex_c(x, which = 1, reverse = FALSE, ...)

scale_color_palettehex_c(x, which = 1, reverse = FALSE, ...)

scale_fill_palettehex_c(x, which = 1, reverse = FALSE, ...)
}
\arguments{
\item{x}{object of class \code{palettehex}}

\item{which}{selection of which palette of a set to choose. Either by name,
id or numeric index.}

\item{reverse}{logical. If scale should b reversed (default: FALSE)}

\item{...}{arguments to be passed to \code{\link[ggplot2]{discrete_scale}}}
}
\value{
ggplot2-proto
}
\description{
Colour and fill scales for ggplot2
plots, using object of class \code{palettehex}.
}
\details{
The \code{palettehex} class is a data.frame of
many palettes. This function takes such a data.frame
and a choice of palette by name, id or numeric index
can be made for the scale.
}
\section{Functions}{
\itemize{
\item \code{scale_colour_palettehex_d}: Discrete colour scale

\item \code{scale_color_palettehex_d}: Discrete colour scale

\item \code{scale_fill_palettehex_d}: Discrete fill scale

\item \code{scale_colour_palettehex_c}: Continuous colour scale

\item \code{scale_color_palettehex_c}: Continuous colour scale

\item \code{scale_fill_palettehex_c}: Continuous fill scale
}}

\examples{
library(ggplot2)

x <- get_popular_palettes()

ggplot(mtcars, aes(mpg)) +
   geom_density(aes(fill = disp, group = disp)) +
   scale_fill_palettehex_c(x)

ggplot(mtcars, aes(mpg)) +
  geom_density(aes(fill = disp, group = disp)) +
  scale_fill_palettehex_c(x, 3)

ggplot(mtcars, aes(mpg, disp, colour = factor(cyl))) +
   geom_point() +
   scale_color_palettehex_d(x)

ggplot(mtcars, aes(mpg, disp, colour = factor(cyl))) +
   geom_point() +
   scale_color_palettehex_d(x, 1872)
}
