% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_visualization.R
\name{plotClustersMulti}
\alias{plotClustersMulti}
\title{Plot several different cluster sets together}
\usage{
plotClustersMulti(clusterList, hsv = FALSE, p = "all", title = "")
}
\arguments{
\item{clusterList}{A list of identically sized dataframes with 4 columns each
(R, G, B, Pct or H, S, V, Pct) as output by \code{extractClusters} or
\code{getHistList}.}

\item{hsv}{Logical. Should HSV axes be used instead of RGB?}

\item{p}{Numeric vector of indices for which elements to plot; otherwise all
of the cluster sets provided will be plotted together.}

\item{title}{Optional title for the plot.}
}
\value{
A single \code{\link{plotly}{plot_ly}} plot of every cluster in a
  list of cluster sets. Each cluster is colored by cluster color,
  proportional to cluster size, and labeled according to the image from which
  it originated.
}
\description{
Plots cluster sets from several different dataframes on a single plot for
easy comparison.
}
\note{
Each cluster plotted is colored according to its actual color, and
labeled according to the image from which it originated.
}
\examples{

\dontrun{
# Takes >10 seconds
clusterList <- colordistance::getHistList(dir(system.file("extdata",
"Heliconius/", package="colordistance"), full.names=TRUE), plotting=FALSE,
lower=rep(0.8, 3), upper=rep(1, 3))

colordistance::plotClustersMulti(clusterList, p=c(1:4), title="Orange and
black Heliconius")

colordistance::plotClustersMulti(clusterList, p=c(5:8), title="Black, yellow,
and red Heliconius")

clusterListHSV <- colordistance::getHistList(dir(system.file("extdata",
"Heliconius/", package="colordistance"), full.names=TRUE), hsv=TRUE,
plotting=FALSE, lower=rep(0.8, 3), upper=rep(1, 3))

colordistance::plotClustersMulti(clusterListHSV, p=c(1:3, 7:8), hsv=TRUE)
}
}
