% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{generateMoboPlot}
\alias{generateMoboPlot}
\title{Generate a Multi-objective Optimization Plot}
\usage{
generateMoboPlot(
  data,
  x,
  y,
  fillColourGroup = "ConditionID",
  ytext,
  legendPos = c(0.65, 0.85),
  numberSamplingSteps = 5,
  labelPosFormulaY = "top",
  verticalLinePosY = 0.75
)
}
\arguments{
\item{data}{A data frame containing the data to be plotted.}

\item{x}{A string representing the column name in \code{data} to be used for the x-axis. Can be either numeric or factor.}

\item{y}{A string representing the column name in \code{data} to be used for the y-axis. This should be a numeric variable.}

\item{fillColourGroup}{A string representing the column name in \code{data} that defines the fill color grouping for the plot. Default is \code{"ConditionID"}.}

\item{ytext}{A custom label for the y-axis. If not provided, the y-axis label will be the title-cased version of \code{y}.}

\item{legendPos}{A numeric vector of length 2 specifying the position of the legend inside the plot. Default is \code{c(0.65, 0.85)}.}

\item{numberSamplingSteps}{An integer specifying the number of initial sampling steps before the optimization phase begins. Default is 5.}

\item{labelPosFormulaY}{A string specifying the vertical position of the polynomial equation label in the plot. Acceptable values are \code{"top"}, \code{"center"}, or \code{"bottom"}. Default is \code{"top"}.}

\item{verticalLinePosY}{A numeric value of the y-coordinate where the "sampling" and "optimizatin" line should be drawn.}
}
\value{
A \code{ggplot} object representing the multi-objective optimization plot, ready to be rendered.
}
\description{
This function generates a multi-objective optimization plot using \code{ggplot2}. The plot visualizes the relationship between the \code{x} and \code{y} variables, grouping and coloring by a fill variable, with the option to customize legend position, labels, and annotation of sampling and optimization phases.
}
\examples{
library(ggplot2)
library(ggpmisc)

# Example with numeric x-axis
df <- data.frame(
  x = 1:20,
  y = rnorm(20),
  ConditionID = rep(c("A", "B"), 10)
)
generateMoboPlot(df, x = "x", y = "y")

# Example with factor x-axis
df <- data.frame(
  x = factor(rep(1:5, each = 4)),
  y = rnorm(20),
  ConditionID = rep(c("A", "B"), 10)
)
generateMoboPlot(df, x = "x", y = "y", numberSamplingSteps = 3)
}
