context("Deque")

test_that("push and pop", {
    q <- Deque$new()
    q$push(1)
    q$push(2)
    expect_equal(q$size(), 2)
    expect_equal(q$pop(), 2)
    expect_equal(q$size(), 1)
    q$push(3)
    expect_equal(q$size(), 2)
    expect_equal(q$pop(), 3)
    expect_equal(q$pop(), 1)
    expect_equal(q$size(), 0)
    expect_error(q$pop(), "empty")
})


test_that("push and pop", {
    q <- Deque$new()
    q$pushleft(1)
    q$pushleft(2)
    expect_equal(q$size(), 2)
    expect_equal(q$popleft(), 2)
    expect_equal(q$size(), 1)
    q$pushleft(3)
    expect_equal(q$size(), 2)
    expect_equal(q$popleft(), 3)
    expect_equal(q$popleft(), 1)
    expect_equal(q$size(), 0)
    expect_error(q$pop(), "empty")
})

test_that("random push and pop", {
    q <- Deque$new()
    q$pushleft(1)
    q$push("a")
    q$pushleft(2)
    q$push("b")
    expect_equal(q$size(), 4)
    expect_equal(q$popleft(), 2)
    expect_equal(q$size(), 3)
    expect_equal(q$pop(), "b")
    expect_equal(q$size(), 2)
    expect_equal(q$popleft(), 1)
    expect_equal(q$size(), 1)
    expect_equal(q$pop(), "a")
    expect_equal(q$size(), 0)
    expect_error(q$pop(), "empty")
    expect_error(q$popleft(), "empty")
})

test_that("random push and pop 2", {
    q <- Deque$new()
    q$push("a")
    q$pushleft(1)
    q$push("b")
    q$pushleft(2)
    expect_equal(q$size(), 4)
    expect_equal(q$pop(), "b")
    expect_equal(q$size(), 3)
    expect_equal(q$popleft(), 2)
    expect_equal(q$size(), 2)
    expect_equal(q$pop(), "a")
    expect_equal(q$size(), 1)
    expect_equal(q$popleft(), 1)
    expect_equal(q$size(), 0)
    expect_error(q$pop(), "empty")
    expect_error(q$popleft(), "empty")
})

test_that("remove", {
    q <- Deque$new()
    q$push("a")
    q$pushleft(1)
    q$push("b")
    q$pushleft(2)
    expect_equal(q$size(), 4)
    q$remove("a")
    expect_equal(q$size(), 3)
    expect_equal(q$pop(), "b")
    expect_equal(q$size(), 2)
    q$remove(1)
    expect_equal(q$size(), 1)
    expect_equal(q$pop(), 2)
})
